/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.trackfiles.impl;

import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class CompressedStreamsUtil {
    private static final Logger logger = Logger.getLogger(CompressedStreamsUtil.class.getName());
    private static final String GZIP_SUFFIX = ".gz";

    private CompressedStreamsUtil() {
    }

    public static void handlePotentiallyCompressedFiles(String filename, InputStream inputStream, Charset charset, FileHandler fileHandler) throws IOException, FormatNotSupportedException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream stream = inputStream;){
            if (filename.toLowerCase().endsWith(".zip")) {
                ZipEntry entry;
                logger.info("Bravo file " + filename + " is a ZIP file");
                ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                while ((entry = zipInputStream.getNextEntry()) != null) {
                    fileHandler.handle(entry.getName(), zipInputStream, charset);
                }
            } else if (filename.toLowerCase().endsWith(GZIP_SUFFIX)) {
                GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);
                String actualFileName = filename.substring(0, filename.length() - GZIP_SUFFIX.length());
                fileHandler.handle(actualFileName, gzipInputStream, charset);
            } else {
                fileHandler.handle(filename, inputStream, charset);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static interface FileHandler {
        public void handle(String var1, InputStream var2, Charset var3) throws IOException, FormatNotSupportedException;
    }
}

