/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.trackfiles.impl;

import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifierImpl;
import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.domain.trackimport.GPSFixImporter;
import com.sap.sailing.server.trackfiles.common.BaseGPSFixImporterImpl;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import slash.navigation.base.BaseNavigationPosition;
import slash.navigation.base.BaseRoute;
import slash.navigation.base.NavigationFormat;
import slash.navigation.base.NavigationFormatParser;
import slash.navigation.base.ParserResult;

public abstract class BaseRouteConverterGPSFixImporterImpl
extends BaseGPSFixImporterImpl {
    private final List<NavigationFormat> supportedReadFormats;

    public BaseRouteConverterGPSFixImporterImpl(List<Class<? extends NavigationFormat<?>>> supportedFormats) {
        this.supportedReadFormats = BaseRouteConverterGPSFixImporterImpl.getFormatInstances(supportedFormats, false);
    }

    private static List<NavigationFormat> getFormatInstances(List<Class<? extends NavigationFormat<?>>> supportedFormats, boolean restrictToWritableFormats) {
        ArrayList<NavigationFormat> formats = new ArrayList<NavigationFormat>();
        for (Class<NavigationFormat<?>> formatClass : supportedFormats) {
            try {
                NavigationFormat<?> format = formatClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if ((!restrictToWritableFormats || !format.isSupportsWriting()) && (restrictToWritableFormats || !format.isSupportsReading())) continue;
                formats.add(format);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot instantiate " + formatClass, e);
            }
        }
        return formats;
    }

    public abstract GPSFix convertToGPSFix(BaseNavigationPosition var1) throws Exception;

    public boolean importFixes(InputStream inputStream, Charset charset, GPSFixImporter.Callback callback, boolean inferSpeedAndBearing, String sourceName) throws IOException, FormatNotSupportedException {
        List routes;
        NavigationFormatParser parser = new NavigationFormatParser();
        try {
            ParserResult result = parser.read(inputStream, 0x40000000, null, this.supportedReadFormats);
            if (result == null) {
                throw new FormatNotSupportedException();
            }
            routes = result.isSuccessful() ? result.getAllRoutes() : Collections.emptyList();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        AtomicBoolean importedFixes = new AtomicBoolean(false);
        for (BaseRoute route : routes) {
            List positions = route.getPositions();
            String routeName = route.getName();
            TrackFileImportDeviceIdentifierImpl device = new TrackFileImportDeviceIdentifierImpl(sourceName, routeName);
            for (BaseNavigationPosition p : positions) {
                try {
                    this.addFixAndInfer(callback, inferSpeedAndBearing, this.convertToGPSFix(p), (TrackFileImportDeviceIdentifier)device);
                    importedFixes.set(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return importedFixes.get();
    }
}

