/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.trackfiles.impl;

import com.sap.sailing.domain.common.tracking.impl.DoubleVectorFixImpl;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifierImpl;
import com.sap.sailing.domain.trackimport.BaseDoubleVectorFixImporter;
import com.sap.sailing.domain.trackimport.DoubleVectorFixImporter;
import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.server.trackfiles.impl.AbstractDoubleVectorFixImporter;
import com.sap.sailing.server.trackfiles.impl.doublefix.DoubleFixProcessor;
import com.sap.sailing.server.trackfiles.impl.doublefix.DoubleVectorFixData;
import com.sap.sailing.server.trackfiles.impl.doublefix.DownsamplerTo1HzProcessor;
import com.sap.sailing.server.trackfiles.impl.doublefix.LearningBatchProcessor;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class BaseBravoDataImporterImpl
extends AbstractDoubleVectorFixImporter {
    private final Logger LOG = Logger.getLogger(DoubleVectorFixImporter.class.getName());
    private final String BOF = "jjlDATE\tjjlTIME\tEpoch";
    private final Map<String, Integer> columnNamesInFileAndTheirValueIndexInResultingDoubleVectorFix;

    public BaseBravoDataImporterImpl(Map<String, Integer> columnNamesInFileAndTheirValueIndexInResultingDoubleVectorFix, String type) {
        super(type);
        this.columnNamesInFileAndTheirValueIndexInResultingDoubleVectorFix = columnNamesInFileAndTheirValueIndexInResultingDoubleVectorFix;
    }

    public boolean importFixes(InputStream inputStream, Charset charset, BaseDoubleVectorFixImporter.Callback callback, String filename, String sourceName, boolean downsample) throws FormatNotSupportedException, IOException {
        InputStreamReader isr;
        TrackFileImportDeviceIdentifierImpl trackIdentifier = new TrackFileImportDeviceIdentifierImpl(UUID.randomUUID(), filename, sourceName, MillisecondsTimePoint.now());
        this.LOG.fine("Import CSV from " + filename);
        if (sourceName.endsWith("gz")) {
            this.LOG.fine("Using gzip stream reader " + filename);
            isr = new InputStreamReader(new GZIPInputStream(inputStream));
        } else {
            isr = new InputStreamReader(inputStream);
        }
        this.LOG.fine("Start parsing bravo file");
        AtomicLong lineNr = new AtomicLong();
        BufferedReader buffer = new BufferedReader(isr);
        String headerLine = null;
        while (headerLine == null) {
            this.LOG.fine("Searching for header in bravo file");
            String headerCandidate = buffer.readLine();
            lineNr.incrementAndGet();
            if (headerCandidate == null) {
                throw new FormatNotSupportedException("Missing required header in file " + filename);
            }
            if (!headerCandidate.startsWith("jjlDATE\tjjlTIME\tEpoch")) continue;
            this.LOG.fine("Found header");
            headerLine = headerCandidate;
            break;
        }
        this.LOG.fine("Validate and parse header columns");
        Map<String, Integer> colIndices = this.validateAndParseHeader(headerLine);
        DoubleFixProcessor downsampler = downsample ? this.createDownsamplingProcessor(callback, (TrackFileImportDeviceIdentifier)trackIdentifier) : arg_0 -> BaseBravoDataImporterImpl.lambda$0(callback, (TrackFileImportDeviceIdentifier)trackIdentifier, arg_0);
        AtomicBoolean importedFixes = new AtomicBoolean(false);
        buffer.lines().forEach(line -> {
            lineNr.incrementAndGet();
            downsampler.accept(this.parseLine(lineNr.get(), filename, (String)line, colIndices));
            importedFixes.set(true);
        });
        downsampler.finish();
        return importedFixes.get();
    }

    protected DoubleFixProcessor createDownsamplingProcessor(BaseDoubleVectorFixImporter.Callback callback, TrackFileImportDeviceIdentifier trackIdentifier) {
        LearningBatchProcessor batchProcessor = new LearningBatchProcessor(5000, 5000, callback, trackIdentifier);
        DownsamplerTo1HzProcessor downsampler = new DownsamplerTo1HzProcessor(this.getTrackColumnCount(), batchProcessor);
        return downsampler;
    }

    private DoubleVectorFixData parseLine(long lineNr, String filename, String line, Map<String, Integer> columnsInFileFromHeader) {
        try {
            DoubleVectorFixData result;
            String[] fileContentTokens = this.split(line);
            String epochColValue = fileContentTokens[2];
            if (epochColValue != null && epochColValue.length() > 0) {
                epochColValue = epochColValue.substring(0, epochColValue.indexOf("."));
                long epoch = Long.parseLong(epochColValue);
                Double[] trackFixData = new Double[this.getTrackColumnCount()];
                for (Map.Entry<String, Integer> columnNameToSearchForInFile : this.columnNamesInFileAndTheirValueIndexInResultingDoubleVectorFix.entrySet()) {
                    Integer columnsInFileIdx = columnsInFileFromHeader.get(columnNameToSearchForInFile.getKey());
                    trackFixData[columnNameToSearchForInFile.getValue().intValue()] = Double.parseDouble(fileContentTokens[columnsInFileIdx]);
                }
                result = new DoubleVectorFixData(epoch, trackFixData);
            } else {
                result = null;
            }
            return result;
        }
        catch (Exception e) {
            this.LOG.warning("Error parsing line nr " + lineNr + " in file " + filename + "with exception: " + e.getMessage());
            return null;
        }
    }

    private Map<String, Integer> validateAndParseHeader(String headerLine) {
        String[] headerTokens = this.split(headerLine);
        HashMap<String, Integer> colIndicesInFile = new HashMap<String, Integer>();
        int j = 3;
        while (j < headerTokens.length) {
            String header = headerTokens[j];
            colIndicesInFile.put(header, j);
            ++j;
        }
        Set<String> requiredColumnsInFix = this.columnNamesInFileAndTheirValueIndexInResultingDoubleVectorFix.keySet();
        if (!Util.containsAll(colIndicesInFile.keySet(), requiredColumnsInFix)) {
            HashSet missingColumns = new HashSet();
            Util.addAll(requiredColumnsInFix, missingColumns);
            missingColumns.removeAll(colIndicesInFile.keySet());
            this.LOG.log(Level.SEVERE, "Missing headers: " + missingColumns);
            StringBuilder errorMessage = new StringBuilder("Missing headers ").append(String.join((CharSequence)", ", missingColumns)).append(" in import file");
            throw new RuntimeException(errorMessage.toString());
        }
        return colIndicesInFile;
    }

    private String[] split(String line) {
        return line.split("\t");
    }

    private int getTrackColumnCount() {
        return Collections.max(this.columnNamesInFileAndTheirValueIndexInResultingDoubleVectorFix.values()) + 1;
    }

    private static /* synthetic */ void lambda$0(BaseDoubleVectorFixImporter.Callback callback, TrackFileImportDeviceIdentifier trackFileImportDeviceIdentifier, DoubleVectorFixData fix) {
        callback.addFixes(Collections.singleton(new DoubleVectorFixImpl(fix.getTimepoint(), fix.getFix())), trackFileImportDeviceIdentifier);
    }
}

