/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.shared.persistence.impl;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOptions;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.coursetemplate.CommonMarkProperties;
import com.sap.sailing.domain.coursetemplate.CourseTemplate;
import com.sap.sailing.domain.coursetemplate.FixedPositioning;
import com.sap.sailing.domain.coursetemplate.MarkProperties;
import com.sap.sailing.domain.coursetemplate.MarkRole;
import com.sap.sailing.domain.coursetemplate.MarkTemplate;
import com.sap.sailing.domain.coursetemplate.PositioningVisitor;
import com.sap.sailing.domain.coursetemplate.TrackingDeviceBasedPositioning;
import com.sap.sailing.domain.coursetemplate.WaypointTemplate;
import com.sap.sailing.shared.persistence.MongoObjectFactory;
import com.sap.sailing.shared.persistence.device.DeviceIdentifierMongoHandler;
import com.sap.sailing.shared.persistence.device.impl.PlaceHolderDeviceIdentifierMongoHandler;
import com.sap.sailing.shared.persistence.impl.CollectionNames;
import com.sap.sailing.shared.persistence.impl.FieldNames;
import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TransformationException;
import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.common.TypeBasedServiceFinderFactory;
import com.sap.sse.common.Util;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoObjectFactoryImpl
implements MongoObjectFactory {
    private static final Logger logger = Logger.getLogger(MongoObjectFactoryImpl.class.getName());
    private final MongoDatabase database;
    private final TypeBasedServiceFinder<DeviceIdentifierMongoHandler> deviceIdentifierServiceFinder;

    public MongoObjectFactoryImpl(MongoDatabase mongoDatabase) {
        this(mongoDatabase, null);
    }

    public MongoObjectFactoryImpl(MongoDatabase mongoDatabase, TypeBasedServiceFinderFactory serviceFinderFactory) {
        this.database = mongoDatabase;
        if (serviceFinderFactory != null) {
            this.deviceIdentifierServiceFinder = serviceFinderFactory.createServiceFinder(DeviceIdentifierMongoHandler.class);
            this.deviceIdentifierServiceFinder.setFallbackService((Object)new PlaceHolderDeviceIdentifierMongoHandler());
        } else {
            this.deviceIdentifierServiceFinder = null;
        }
    }

    @Override
    public MongoDatabase getDatabase() {
        return this.database;
    }

    @Override
    public void storeMarkProperties(TypeBasedServiceFinder<DeviceIdentifierMongoHandler> deviceIdentifierServiceFinder, MarkProperties markProperties) {
        MongoCollection collection = this.database.getCollection(CollectionNames.MARK_PROPERTIES.name());
        Document query = new Document(FieldNames.MARK_PROPERTIES_ID.name(), (Object)markProperties.getId().toString());
        try {
            Document entry = this.storeMarkPropertiesToDocument(deviceIdentifierServiceFinder, markProperties);
            collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)entry, new ReplaceOptions().upsert(true));
        }
        catch (NoCorrespondingServiceRegisteredException | TransformationException e) {
            logger.log(Level.WARNING, "Could not load mark properties because device identifier could not be stored.", e);
        }
    }

    private Document storeMarkPropertiesToDocument(final TypeBasedServiceFinder<DeviceIdentifierMongoHandler> deviceIdentifierServiceFinder, MarkProperties markProperties) throws TransformationException, NoCorrespondingServiceRegisteredException {
        final Document result = new Document();
        result.put(FieldNames.MARK_PROPERTIES_ID.name(), (Object)markProperties.getId().toString());
        this.storeCommonMarkProperties((CommonMarkProperties)markProperties, result);
        if (markProperties.getPositioningInformation() != null) {
            markProperties.getPositioningInformation().accept((PositioningVisitor)new PositioningVisitor<Void>(){

                public Void visit(FixedPositioning fixedPositioning) {
                    result.put(FieldNames.MARK_PROPERTIES_FIXED_POSITION.name(), (Object)MongoObjectFactoryImpl.this.storePosition(fixedPositioning.getFixedPosition()));
                    return null;
                }

                public Void visit(TrackingDeviceBasedPositioning trackingDeviceBasedPositioning) {
                    try {
                        result.put(FieldNames.MARK_PROPERTIES_TRACKING_DEVICE_IDENTIFIER.name(), (Object)MongoObjectFactoryImpl.storeDeviceId((TypeBasedServiceFinder<DeviceIdentifierMongoHandler>)deviceIdentifierServiceFinder, trackingDeviceBasedPositioning.getDeviceIdentifier()));
                        return null;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        BasicDBList tags = new BasicDBList();
        if (markProperties.getTags() != null) {
            markProperties.getTags().forEach(arg_0 -> tags.add(arg_0));
        }
        result.put(FieldNames.MARK_PROPERTIES_TAGS.name(), (Object)tags);
        Map<String, Long> lastUsedTemplateMap = markProperties.getLastUsedMarkTemplate().entrySet().stream().collect(Collectors.toMap(k -> ((MarkTemplate)k.getKey()).getId().toString(), v -> ((TimePoint)v.getValue()).asMillis()));
        result.put(FieldNames.MARK_PROPERTIES_USED_TEMPLATE.name(), (Object)new BasicDBObject(lastUsedTemplateMap));
        Map<String, Long> lastUsedRoleMap = markProperties.getLastUsedMarkRole().entrySet().stream().collect(Collectors.toMap(k -> ((MarkRole)k.getKey()).getId().toString(), v -> ((TimePoint)v.getValue()).asMillis()));
        result.put(FieldNames.MARK_PROPERTIES_USED_ROLE.name(), (Object)new BasicDBObject(lastUsedRoleMap));
        return result;
    }

    public static Document storeDeviceId(TypeBasedServiceFinder<DeviceIdentifierMongoHandler> deviceIdentifierServiceFinder, DeviceIdentifier device) throws TransformationException, NoCorrespondingServiceRegisteredException {
        Document result;
        if (device == null) {
            result = null;
        } else {
            String type = device.getIdentifierType();
            DeviceIdentifierMongoHandler handler = (DeviceIdentifierMongoHandler)deviceIdentifierServiceFinder.findService(type);
            Util.Pair pair = handler.serialize(device);
            type = (String)pair.getA();
            Object deviceTypeSpecificId = pair.getB();
            result = new Document().append(FieldNames.DEVICE_TYPE.name(), (Object)type).append(FieldNames.DEVICE_TYPE_SPECIFIC_ID.name(), deviceTypeSpecificId).append(FieldNames.DEVICE_STRING_REPRESENTATION.name(), (Object)device.getStringRepresentation());
        }
        return result;
    }

    public static Bson getDeviceQuery(TypeBasedServiceFinder<DeviceIdentifierMongoHandler> deviceIdentifierServiceFinder, DeviceIdentifier device) throws TransformationException, NoCorrespondingServiceRegisteredException {
        Bson result;
        if (device == null) {
            result = null;
        } else {
            String type = device.getIdentifierType();
            DeviceIdentifierMongoHandler handler = (DeviceIdentifierMongoHandler)deviceIdentifierServiceFinder.findService(type);
            Util.Pair pair = handler.serialize(device);
            type = (String)pair.getA();
            Object deviceTypeSpecificId = pair.getB();
            result = Filters.and((Bson[])new Bson[]{Filters.eq((String)(String.valueOf(FieldNames.DEVICE_ID.name()) + "." + FieldNames.DEVICE_STRING_REPRESENTATION.name()), (Object)device.getStringRepresentation()), Filters.eq((String)(String.valueOf(FieldNames.DEVICE_ID.name()) + "." + FieldNames.DEVICE_TYPE_SPECIFIC_ID.name()), (Object)deviceTypeSpecificId), Filters.eq((String)(String.valueOf(FieldNames.DEVICE_ID.name()) + "." + FieldNames.DEVICE_TYPE.name()), (Object)type)});
        }
        return result;
    }

    private Document storePosition(Position position) {
        Document result;
        if (position == null) {
            result = null;
        } else {
            result = new Document();
            result.put(FieldNames.LAT_DEG.name(), (Object)position.getLatDeg());
            result.put(FieldNames.LNG_DEG.name(), (Object)position.getLngDeg());
        }
        return result;
    }

    private void storeCommonMarkProperties(CommonMarkProperties markProperties, Document result) {
        if (markProperties.getColor() != null) {
            result.put(FieldNames.COMMON_MARK_PROPERTIES_COLOR.name(), (Object)markProperties.getColor().getAsHtml());
        }
        result.put(FieldNames.COMMON_MARK_PROPERTIES_NAME.name(), (Object)markProperties.getName());
        result.put(FieldNames.COMMON_MARK_PROPERTIES_PATTERN.name(), (Object)markProperties.getPattern());
        result.put(FieldNames.COMMON_MARK_PROPERTIES_SHAPE.name(), (Object)markProperties.getShape());
        result.put(FieldNames.COMMON_MARK_PROPERTIES_SHORT_NAME.name(), (Object)markProperties.getShortName());
        result.put(FieldNames.COMMON_MARK_PROPERTIES_TYPE.name(), markProperties.getType() == null ? null : markProperties.getType().name());
    }

    @Override
    public void removeMarkProperties(UUID markPropertiesId) {
        MongoCollection configurationsCollections = this.database.getCollection(CollectionNames.MARK_PROPERTIES.name());
        Document query = new Document(FieldNames.MARK_PROPERTIES_ID.name(), (Object)markPropertiesId.toString());
        configurationsCollections.deleteOne((Bson)query);
    }

    @Override
    public void storeMarkTemplate(MarkTemplate markTemplate) {
        MongoCollection collection = this.database.getCollection(CollectionNames.MARK_TEMPLATES.name());
        Document query = new Document(FieldNames.MARK_TEMPLATE_ID.name(), (Object)markTemplate.getId().toString());
        Document entry = this.storeMarkTemplateToDocument(markTemplate);
        collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)entry, new ReplaceOptions().upsert(true));
    }

    private Document storeMarkTemplateToDocument(MarkTemplate markTemplate) {
        Document result = new Document(FieldNames.MARK_TEMPLATE_ID.name(), (Object)markTemplate.getId().toString());
        this.storeCommonMarkProperties((CommonMarkProperties)markTemplate, result);
        return result;
    }

    @Override
    public void removeMarkTemplate(UUID markTemplateId) {
        MongoCollection configurationsCollections = this.database.getCollection(CollectionNames.MARK_TEMPLATES.name());
        Document query = new Document(FieldNames.MARK_TEMPLATE_ID.name(), (Object)markTemplateId.toString());
        configurationsCollections.deleteOne((Bson)query);
    }

    @Override
    public void storeMarkRole(MarkRole markRole) {
        MongoCollection collection = this.database.getCollection(CollectionNames.MARK_ROLES.name());
        Document query = new Document(FieldNames.MARK_ROLE_ID.name(), (Object)markRole.getId().toString());
        Document entry = this.storeMarkRoleToDocument(markRole);
        collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)entry, new ReplaceOptions().upsert(true));
    }

    private Document storeMarkRoleToDocument(MarkRole markRole) {
        Document result = new Document(FieldNames.MARK_ROLE_ID.name(), (Object)markRole.getId().toString());
        result.put(FieldNames.MARK_ROLE_NAME.name(), (Object)markRole.getName());
        result.put(FieldNames.MARK_ROLE_SHORT_NAME.name(), (Object)markRole.getShortName());
        return result;
    }

    @Override
    public void removeMarkRole(UUID markRoleId) {
        MongoCollection configurationsCollections = this.database.getCollection(CollectionNames.MARK_ROLES.name());
        Document query = new Document(FieldNames.MARK_ROLE_ID.name(), (Object)markRoleId.toString());
        configurationsCollections.deleteOne((Bson)query);
    }

    @Override
    public void storeCourseTemplate(CourseTemplate courseTemplate) {
        MongoCollection collection = this.database.getCollection(CollectionNames.COURSE_TEMPLATES.name());
        Document query = new Document(FieldNames.COURSE_TEMPLATE_ID.name(), (Object)courseTemplate.getId().toString());
        Document entry = this.storeCourseTemplateToDocument(courseTemplate);
        collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)query, (Object)entry, new ReplaceOptions().upsert(true));
    }

    private Document storeCourseTemplateToDocument(CourseTemplate courseTemplate) {
        Document result = new Document();
        result.put(FieldNames.COURSE_TEMPLATE_ID.name(), (Object)courseTemplate.getId().toString());
        result.put(FieldNames.COURSE_TEMPLATE_NAME.name(), (Object)courseTemplate.getName());
        result.put(FieldNames.COURSE_TEMPLATE_SHORT_NAME.name(), (Object)courseTemplate.getShortName());
        result.put(FieldNames.COURSE_TEMPLATE_DEFAULT_NUMBER_OF_LAPS.name(), (Object)courseTemplate.getDefaultNumberOfLaps());
        URL optionalImageURL = courseTemplate.getOptionalImageURL();
        if (optionalImageURL != null) {
            result.put(FieldNames.COURSE_TEMPLATE_IMAGE_URL.name(), (Object)optionalImageURL.toExternalForm());
        }
        BasicDBList markRoles = new BasicDBList();
        courseTemplate.getDefaultMarkTemplatesForMarkRoles().forEach((role, mt) -> {
            BasicDBObject markRoleObject = new BasicDBObject(FieldNames.COURSE_TEMPLATE_MARK_ROLE_ID.name(), (Object)role.getId().toString());
            markRoleObject.append(FieldNames.COURSE_TEMPLATE_MARK_TEMPLATE_ID.name(), (Object)mt.getId().toString());
            markRoles.add((Object)markRoleObject);
        });
        result.put(FieldNames.COURSE_TEMPLATE_MARK_ROLES.name(), (Object)markRoles);
        BasicDBList markTemplates = new BasicDBList();
        courseTemplate.getDefaultMarkRolesForMarkTemplates().forEach((m, role) -> {
            BasicDBObject markTemplateObject = new BasicDBObject(FieldNames.COURSE_TEMPLATE_MARK_TEMPLATE_ID.name(), (Object)m.getId().toString());
            if (role != null) {
                markTemplateObject.append(FieldNames.COURSE_TEMPLATE_MARK_TEMPLATE_ROLE_ID.name(), (Object)role.getId().toString());
            }
            markTemplates.add((Object)markTemplateObject);
        });
        result.put(FieldNames.COURSE_TEMPLATE_MARK_TEMPLATES.name(), (Object)markTemplates);
        BasicDBList waypointTemplates = new BasicDBList();
        for (WaypointTemplate waypointTemplate : courseTemplate.getWaypointTemplates()) {
            BasicDBObject waypointTemplateObject = this.storeWaypointTemplate(waypointTemplate);
            waypointTemplates.add((Object)waypointTemplateObject);
        }
        result.put(FieldNames.COURSE_TEMPLATE_WAYPOINTS.name(), (Object)waypointTemplates);
        BasicDBList tags = new BasicDBList();
        if (courseTemplate.getTags() != null) {
            courseTemplate.getTags().forEach(arg_0 -> tags.add(arg_0));
        }
        result.put(FieldNames.COURSE_TEMPLATE_TAGS.name(), (Object)tags);
        if (courseTemplate.hasRepeatablePart()) {
            BasicDBObject repeatablePart = this.storeRepeatablePart(courseTemplate);
            result.put(FieldNames.COURSE_TEMPLATE_REPEATABLE_PART.name(), (Object)repeatablePart);
        }
        return result;
    }

    private BasicDBObject storeWaypointTemplate(WaypointTemplate waypointTemplate) {
        BasicDBObject waypointTemplateObject = new BasicDBObject();
        waypointTemplateObject.put((Object)FieldNames.WAYPOINT_TEMPLATE_PASSINGINSTRUCTION.name(), (Object)MongoObjectFactoryImpl.getPassingInstructions(waypointTemplate.getPassingInstruction()));
        waypointTemplateObject.put((Object)FieldNames.WAYPOINT_TEMPLATE_CONTROL_POINT_NAME.name(), (Object)waypointTemplate.getControlPointTemplate().getName());
        waypointTemplateObject.put((Object)FieldNames.WAYPOINT_TEMPLATE_CONTROL_POINT_SHORT_NAME.name(), (Object)waypointTemplate.getControlPointTemplate().getShortName());
        BasicDBList markRoles = new BasicDBList();
        waypointTemplate.getControlPointTemplate().getMarkRoles().forEach(m -> {
            boolean bl = markRoles.add((Object)m.getId().toString());
        });
        waypointTemplateObject.put((Object)FieldNames.WAYPOINT_TEMPLATE_MARK_ROLES.name(), (Object)markRoles);
        return waypointTemplateObject;
    }

    public static String getPassingInstructions(PassingInstruction passingInstructions) {
        String passing = passingInstructions != null ? passingInstructions.name() : null;
        return passing;
    }

    private BasicDBObject storeRepeatablePart(CourseTemplate courseTemplate) {
        BasicDBObject repeatablePart = new BasicDBObject();
        repeatablePart.put((Object)FieldNames.REPEATABLE_PART_START.name(), (Object)courseTemplate.getRepeatablePart().getZeroBasedIndexOfRepeatablePartStart());
        repeatablePart.put((Object)FieldNames.REPEATABLE_PART_END.name(), (Object)courseTemplate.getRepeatablePart().getZeroBasedIndexOfRepeatablePartEnd());
        return repeatablePart;
    }

    @Override
    public void removeCourseTemplate(UUID courseTemplateId) {
        MongoCollection configurationsCollections = this.database.getCollection(CollectionNames.COURSE_TEMPLATES.name());
        Document query = new Document(FieldNames.COURSE_TEMPLATE_ID.name(), (Object)courseTemplateId.toString());
        configurationsCollections.deleteOne((Bson)query);
    }
}

