/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.orchestration;

import com.jcraft.jsch.JSchException;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.Host;
import com.sap.sse.landscape.ProcessConfigurationVariable;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.aws.AwsInstance;
import com.sap.sse.landscape.aws.HostSupplier;
import com.sap.sse.landscape.aws.Tags;
import com.sap.sse.landscape.aws.impl.AwsInstanceImpl;
import com.sap.sse.landscape.aws.orchestration.StartAwsHost;
import com.sap.sse.landscape.mongodb.MongoProcess;
import com.sap.sse.landscape.mongodb.MongoReplicaSet;
import com.sap.sse.landscape.mongodb.impl.MongoProcessImpl;
import com.sap.sse.landscape.mongodb.impl.MongoProcessInReplicaSetImpl;
import com.sap.sse.shared.util.Wait;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.logging.Level;
import software.amazon.awssdk.services.ec2.model.InstanceStateName;
import software.amazon.awssdk.services.ec2.model.InstanceType;

public class StartMongoDBServer<ShardingKey, ProcessT extends MongoProcess>
extends StartAwsHost<ShardingKey, AwsInstance<ShardingKey>> {
    private ProcessT mongoProcess;
    private final String replicaSetName;
    private final Optional<Duration> optionalTimeout;

    public static <BuilderT extends Builder<BuilderT, ShardingKey, ProcessT>, ShardingKey, ProcessT extends MongoProcess> Builder<BuilderT, ShardingKey, ProcessT> builder() {
        return new BuilderImpl();
    }

    protected StartMongoDBServer(BuilderImpl<?, ShardingKey, ProcessT> builder) throws URISyntaxException, JSchException, IOException, InterruptedException {
        super(builder);
        this.replicaSetName = builder.getReplicaSetName();
        if (builder.getReplicaSetName() != null) {
            this.addUserData(MongoDBReplicaSetUserData.REPLICA_SET_NAME, builder.getReplicaSetName());
        }
        if (builder.getReplicaSetPrimary() != null) {
            this.addUserData(MongoDBReplicaSetUserData.REPLICA_SET_PRIMARY, builder.getReplicaSetPrimary());
        }
        this.addUserData(MongoDBReplicaSetUserData.REPLICA_SET_PRIORITY, Integer.toString(builder.getReplicaSetPriority()));
        this.addUserData(MongoDBReplicaSetUserData.REPLICA_SET_VOTES, Integer.toString(builder.getReplicaSetVotes()));
        this.optionalTimeout = builder.getOptionalTimeout();
    }

    public ProcessT getMongoProcess() {
        return this.mongoProcess;
    }

    @Override
    public void run() throws Exception {
        super.run();
        if (this.replicaSetName == null) {
            MongoProcessImpl mongoProcessCast = new MongoProcessImpl(this.getHost());
            this.mongoProcess = mongoProcessCast;
        } else {
            boolean running = Wait.wait(() -> this.getLandscape().getInstance(this.getHost().getInstanceId(), this.getHost().getRegion()).state().name() == InstanceStateName.RUNNING, this.optionalTimeout, (Duration)Duration.ONE_SECOND.times(5L), (Level)Level.INFO, (String)("Waiting for host " + this.getHost().getInstanceId() + " to be in state RUNNING"));
            if (!running) {
                throw new IllegalStateException("The host launched did not reach state RUNNING" + this.optionalTimeout.map(d -> " within timeout " + d).orElse(""));
            }
            MongoReplicaSet replicaSet = this.getLandscape().getDatabaseConfigurationForReplicaSet(this.getHost().getRegion(), this.replicaSetName);
            Host instance = Util.stream((Iterable)replicaSet.getInstances()).filter(replica -> replica.getHost().equals(this.getHost())).map(replica -> replica.getHost()).findAny().get();
            MongoProcessInReplicaSetImpl mongoProcessCast = new MongoProcessInReplicaSetImpl(replicaSet, 27017, instance);
            this.mongoProcess = mongoProcessCast;
        }
    }

    public static interface Builder<BuilderT extends Builder<BuilderT, ShardingKey, ProcessT>, ShardingKey, ProcessT extends MongoProcess>
    extends StartAwsHost.Builder<BuilderT, StartMongoDBServer<ShardingKey, ProcessT>, ShardingKey, AwsInstance<ShardingKey>> {
        public static final String MONGODB_SERVER_IMAGE_TYPE = "mongodb-server";

        public BuilderT setReplicaSetName(String var1);

        public BuilderT setReplicaSetPrimary(String var1);

        public BuilderT setReplicaSetPriority(int var1);

        public BuilderT setReplicaSetVotes(int var1);
    }

    protected static class BuilderImpl<BuilderT extends Builder<BuilderT, ShardingKey, ProcessT>, ShardingKey, ProcessT extends MongoProcess>
    extends StartAwsHost.BuilderImpl<BuilderT, StartMongoDBServer<ShardingKey, ProcessT>, ShardingKey, AwsInstance<ShardingKey>>
    implements Builder<BuilderT, ShardingKey, ProcessT> {
        private String replicaSetName = "live";
        private String replicaSetPrimary;
        private boolean replicaSetPrimaryWasSetExplicitly = false;
        private int replicaSetPriority = 1;
        private int replicaSetVotes = 1;

        private BuilderImpl() {
            this.setImageType("mongodb-server");
        }

        @Override
        public HostSupplier<ShardingKey, AwsInstance<ShardingKey>> getHostSupplier() {
            return AwsInstanceImpl::new;
        }

        @Override
        public BuilderT setReplicaSetName(String replicaSetName) {
            this.replicaSetName = replicaSetName;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setReplicaSetPrimary(String replicaSetPrimary) {
            this.replicaSetPrimary = replicaSetPrimary;
            this.replicaSetPrimaryWasSetExplicitly = true;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setReplicaSetPriority(int replicaSetPriority) {
            this.replicaSetPriority = replicaSetPriority;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setReplicaSetVotes(int replicaSetVotes) {
            this.replicaSetVotes = replicaSetVotes;
            return (BuilderT)((Builder)this.self());
        }

        protected String getReplicaSetName() {
            return this.replicaSetName;
        }

        protected String getReplicaSetPrimary() throws URISyntaxException, JSchException, IOException, InterruptedException {
            String result;
            if (this.replicaSetPrimary == null) {
                result = this.replicaSetPrimaryWasSetExplicitly ? null : (this.getReplicaSetName() != null ? String.join((CharSequence)",", Util.map((Iterable)Util.filter((Iterable)this.getLandscape().getDatabaseConfigurationForReplicaSet(this.getRegion(), this.getReplicaSetName()).getInstances(), instance -> instance.getHost().getPrivateAddress(this.getOptionalTimeout()) != null), instance -> String.valueOf(instance.getHost().getPrivateAddress(this.getOptionalTimeout()).getHostAddress()) + ":" + instance.getPort())) : null);
            } else {
                if (this.getReplicaSetName() == null) {
                    throw new IllegalStateException("Cannot provide a primary address " + this.replicaSetPrimary + " when no replica set name is specified which means to create a stand-alone process");
                }
                result = this.replicaSetPrimary;
            }
            return result;
        }

        protected int getReplicaSetPriority() {
            return this.replicaSetPriority;
        }

        protected int getReplicaSetVotes() {
            return this.replicaSetVotes;
        }

        @Override
        protected String getInstanceName() {
            String result = super.getInstanceName() != null ? super.getInstanceName() : "MongoDB Replica Set " + this.getReplicaSetName() + " P" + this.getReplicaSetPriority();
            return result;
        }

        @Override
        protected InstanceType getInstanceType() {
            InstanceType result = super.getInstanceType() == null ? InstanceType.I3_LARGE : super.getInstanceType();
            return result;
        }

        public StartMongoDBServer<ShardingKey, ProcessT> build() throws URISyntaxException, JSchException, IOException, InterruptedException {
            this.setTags(this.getLandscape().getTagForMongoProcess(this.getTags().orElse(Tags.empty()), this.getReplicaSetName(), 27017));
            if (!this.isSecurityGroupsSet()) {
                this.setSecurityGroups(this.getLandscape().getDefaultSecurityGroupsForMongoDBHosts((Region)this.getRegion()));
            }
            return new StartMongoDBServer(this);
        }

        protected Optional<Duration> getOptionalTimeout() {
            return super.getOptionalTimeout();
        }
    }

    private static enum MongoDBReplicaSetUserData implements ProcessConfigurationVariable
    {
        REPLICA_SET_NAME,
        REPLICA_SET_PRIMARY,
        REPLICA_SET_PRIORITY,
        REPLICA_SET_VOTES;

    }
}

