/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.impl;

import com.sap.sse.common.Util;
import com.sap.sse.landscape.aws.AwsLandscape;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import software.amazon.awssdk.services.route53.Route53AsyncClient;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;

public class DNSCache {
    private final Route53AsyncClient route53Client;
    private final ConcurrentMap<String, CompletableFuture<String>> hostedZoneNamesToHostedZoneIds;
    private final ConcurrentMap<String, CompletableFuture<Iterable<ResourceRecordSet>>> hostedZoneIdsToResourceRecordSets;

    public DNSCache(Route53AsyncClient route53Client) {
        this.route53Client = route53Client;
        this.hostedZoneNamesToHostedZoneIds = new ConcurrentHashMap<String, CompletableFuture<String>>();
        this.hostedZoneIdsToResourceRecordSets = new ConcurrentHashMap<String, CompletableFuture<Iterable<ResourceRecordSet>>>();
    }

    public CompletableFuture<String> getHostedZoneId(String hostedZoneName) {
        return this.hostedZoneNamesToHostedZoneIds.computeIfAbsent(hostedZoneName, hzn -> this.route53Client.listHostedZonesByName(b -> {
            ListHostedZonesByNameRequest.Builder builder = b.dnsName(hzn);
        }).handle((response, e) -> ((HostedZone)response.hostedZones().iterator().next()).id().replaceFirst("^\\/hostedzone\\/", "")));
    }

    private CompletableFuture<Iterable<ResourceRecordSet>> getResourceRecordSets(String hostedZoneId) {
        ConcurrentLinkedQueue result = new ConcurrentLinkedQueue();
        return this.hostedZoneIdsToResourceRecordSets.computeIfAbsent(hostedZoneId, hzid -> this.route53Client.listResourceRecordSetsPaginator(b -> {
            ListResourceRecordSetsRequest.Builder builder = b.hostedZoneId(hzid);
        }).subscribe(rrs -> {
            boolean bl = result.addAll(rrs.resourceRecordSets());
        }).handle((v, e) -> result));
    }

    public CompletableFuture<Iterable<ResourceRecordSet>> getResourceRecordSetsAsync(String hostname) {
        return ((CompletableFuture)this.getHostedZoneId(AwsLandscape.getHostedZoneName(hostname)).thenCompose(hostedZoneId -> this.getResourceRecordSets((String)hostedZoneId))).handle((resourceRecordSets, e) -> Util.filter((Iterable)resourceRecordSets, resourceRecordSet -> resourceRecordSet.name().replaceFirst("\\.$", "").equals(hostname)));
    }
}

