/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.impl;

import com.sap.sse.common.Util;
import com.sap.sse.common.impl.NamedImpl;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.aws.ApplicationLoadBalancer;
import com.sap.sse.landscape.aws.AwsInstance;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.TargetGroup;
import com.sap.sse.landscape.aws.impl.ApplicationLoadBalancerImpl;
import java.util.Map;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TagDescription;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealth;

public class AwsTargetGroupImpl<ShardingKey>
extends NamedImpl
implements TargetGroup<ShardingKey> {
    private static final long serialVersionUID = -5442598262397393201L;
    private final String arn;
    private final String loadBalancerArn;
    private final AwsLandscape<ShardingKey> landscape;
    private final Region region;
    private final ProtocolEnum protocol;
    private final Integer port;
    private final ProtocolEnum healthCheckProtocol;
    private final Integer healthCheckPort;
    private final String healthCheckPath;

    public AwsTargetGroupImpl(AwsLandscape<ShardingKey> landscape, Region region, String targetGroupName, String arn, String loadBalancerArn, ProtocolEnum protocol, Integer port, ProtocolEnum healthCheckProtocol, Integer healthCheckPort, String healthCheckPath) {
        super(targetGroupName);
        this.arn = arn;
        this.loadBalancerArn = loadBalancerArn;
        this.landscape = landscape;
        this.region = region;
        this.protocol = protocol;
        this.port = port;
        this.healthCheckProtocol = healthCheckProtocol;
        this.healthCheckPort = healthCheckPort;
        this.healthCheckPath = healthCheckPath;
    }

    private software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup getAwsTargetGroup() {
        return this.landscape.getAwsTargetGroupByArn(this.getRegion(), this.getTargetGroupArn());
    }

    @Override
    public Iterable<TagDescription> getTagDescriptions() {
        return this.landscape.getTargetGroupTags(this.arn, this.region);
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public Map<AwsInstance<ShardingKey>, TargetHealth> getRegisteredTargets() {
        return this.landscape.getTargetHealthDescriptions(this);
    }

    @Override
    public ApplicationLoadBalancer<ShardingKey> getLoadBalancer() {
        software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup targetGroup = this.getAwsTargetGroup();
        ApplicationLoadBalancerImpl<ShardingKey> result = targetGroup.hasLoadBalancerArns() && !targetGroup.loadBalancerArns().isEmpty() ? new ApplicationLoadBalancerImpl<ShardingKey>(this.getRegion(), this.landscape.getAwsLoadBalancer((String)targetGroup.loadBalancerArns().iterator().next(), this.getRegion()), this.landscape) : null;
        return result;
    }

    @Override
    public void addTargets(Iterable<AwsInstance<ShardingKey>> targets) {
        if (!Util.isEmpty(targets)) {
            this.landscape.addTargetsToTargetGroup(this, targets);
        }
    }

    @Override
    public void removeTargets(Iterable<AwsInstance<ShardingKey>> targets) {
        if (!Util.isEmpty(targets)) {
            this.landscape.removeTargetsFromTargetGroup(this, targets);
        }
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public ProtocolEnum getProtocol() {
        return this.protocol;
    }

    @Override
    public Integer getHealthCheckPort() {
        return this.healthCheckPort;
    }

    @Override
    public String getHealthCheckPath() {
        return this.healthCheckPath;
    }

    @Override
    public ProtocolEnum getHealthCheckProtocol() {
        return this.healthCheckProtocol;
    }

    @Override
    public String getLoadBalancerArn() {
        return this.loadBalancerArn;
    }

    @Override
    public String getTargetGroupArn() {
        return this.arn;
    }
}

