/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.aws.ApplicationLoadBalancer;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.TargetGroup;
import com.sap.sse.landscape.aws.common.shared.PlainRedirectDTO;
import com.sap.sse.landscape.aws.impl.LoadBalancerRuleInserter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ForwardActionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.HostHeaderConditionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Listener;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.PathPatternConditionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupTuple;

public class ApplicationLoadBalancerImpl<ShardingKey>
implements ApplicationLoadBalancer<ShardingKey> {
    private static final Logger logger = Logger.getLogger(ApplicationLoadBalancerImpl.class.getName());
    private static final long serialVersionUID = -5297220031399131769L;
    private final LoadBalancer loadBalancer;
    private final Region region;
    private final AwsLandscape<ShardingKey> landscape;

    public ApplicationLoadBalancerImpl(Region region, LoadBalancer loadBalancer, AwsLandscape<ShardingKey> landscape) {
        this.region = region;
        this.loadBalancer = loadBalancer;
        this.landscape = landscape;
    }

    @Override
    public AwsLandscape<ShardingKey> getLandscape() {
        return this.landscape;
    }

    public String getName() {
        return this.loadBalancer.loadBalancerName();
    }

    @Override
    public String getDNSName() {
        return this.loadBalancer.dnsName();
    }

    @Override
    public String getArn() {
        return this.loadBalancer.loadBalancerArn();
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public String getVpcId() {
        return this.loadBalancer.vpcId();
    }

    @Override
    public List<String> getSecurityGroupIds() {
        return this.loadBalancer.securityGroups();
    }

    @Override
    public Iterable<Rule> getRules() {
        Listener httpsListener = this.getListener(ProtocolEnum.HTTPS);
        return this.landscape.getLoadBalancerListenerRules(httpsListener, this.getRegion());
    }

    @Override
    public void deleteListener(Listener listener) {
        this.landscape.deleteLoadBalancerListener(this.getRegion(), listener);
    }

    @Override
    public Listener getListener(ProtocolEnum protocol) {
        return (Listener)Util.filter(this.landscape.getListeners(this), l -> l.protocol() == protocol).iterator().next();
    }

    @Override
    public Iterable<Rule> addRules(Rule ... rulesToAdd) {
        return this.landscape.createLoadBalancerListenerRules(this.region, this.getListener(ProtocolEnum.HTTPS), rulesToAdd);
    }

    @Override
    public int getFirstShardingPriority(String hostname) throws IllegalStateException {
        Iterable<Rule> rules = this.getRules();
        TreeMap<Integer, Rule> rulesSorted = this.getRulesSorted(rules);
        Iterator<Map.Entry<Integer, Rule>> iterSorted = rulesSorted.entrySet().iterator();
        int priorityToReturn = -1;
        block0: while (iterSorted.hasNext()) {
            Rule r = iterSorted.next().getValue();
            for (RuleCondition con : r.conditions()) {
                if (con.hostHeaderConfig() == null || !con.hostHeaderConfig().values().contains(hostname)) continue;
                for (Action a : r.actions()) {
                    if (a.forwardConfig() != null) {
                        priorityToReturn = Integer.parseInt(r.priority());
                        break block0;
                    }
                    if (a.redirectConfig() == null) continue;
                    priorityToReturn = Integer.parseInt(r.priority()) + 1;
                    break block0;
                }
            }
            if (iterSorted.hasNext()) continue;
            priorityToReturn = Integer.parseInt(r.priority()) + 1;
            break;
        }
        if (priorityToReturn > 50000) {
            throw new IllegalStateException("Index higher than 50000!");
        }
        return priorityToReturn;
    }

    private TreeMap<Integer, Rule> getRulesSorted(Iterable<Rule> rules) {
        Iterator<Rule> iter = rules.iterator();
        TreeMap<Integer, Rule> rulesSorted = new TreeMap<Integer, Rule>();
        while (iter.hasNext()) {
            Rule r = iter.next();
            try {
                if (r.priority().equalsIgnoreCase("Default")) continue;
                rulesSorted.put(Integer.valueOf(r.priority()), r);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Priority '" + r.priority() + "' couldn't be parsed as an Integer.");
            }
        }
        return rulesSorted;
    }

    @Override
    public Iterable<Rule> addRulesAssigningUnusedPriorities(boolean forceContiguous, Optional<Rule> insertBefore, Rule ... rules) {
        List<Rule> rulesAsList = Arrays.asList(rules);
        return Util.map(LoadBalancerRuleInserter.create(this, 50000, 100).addRulesAssigningUnusedPriorities(forceContiguous, insertBefore.map(LoadBalancerRuleInserter::createRuleAdapter), Util.map(rulesAsList, LoadBalancerRuleInserter::createRuleAdapter)), LoadBalancerRuleInserter.ALBRuleAdapter::getRule);
    }

    @Override
    public void deleteRules(Rule ... rulesToDelete) {
        this.landscape.deleteLoadBalancerListenerRules(this.region, rulesToDelete);
    }

    @Override
    public Iterable<TargetGroup<ShardingKey>> getTargetGroups() {
        return this.landscape.getTargetGroupsByLoadBalancerArn(this.getRegion(), this.getArn());
    }

    private void deleteAllRules() {
        for (Rule rule : this.getRules()) {
            if (rule.isDefault().booleanValue()) continue;
            this.deleteRules(rule);
        }
    }

    @Override
    public void delete() throws InterruptedException {
        HashSet targetGroups = new HashSet();
        Util.addAll(this.getTargetGroups(), targetGroups);
        this.deleteAllRules();
        this.deleteAllListeners();
        this.landscape.deleteLoadBalancer(this);
        Thread.sleep(Duration.ONE_SECOND.times(5L).asMillis());
        for (TargetGroup targetGroup : targetGroups) {
            this.landscape.deleteTargetGroup(targetGroup);
        }
    }

    private void deleteListener(ProtocolEnum protocol) {
        Listener httpListener = this.getListener(protocol);
        if (httpListener != null) {
            this.deleteListener(httpListener);
        }
    }

    private void deleteAllListeners() {
        this.deleteListener(ProtocolEnum.HTTP);
        this.deleteListener(ProtocolEnum.HTTPS);
    }

    @Override
    public Rule setDefaultRedirect(String hostname, String pathWithLeadingSlash, Optional<String> query) {
        return Util.stream(this.getRules()).filter(r -> this.isDefaultRedirectRule((Rule)r, hostname)).findAny().map(defaultRedirectRule -> this.updateDefaultRedirectRule(defaultRedirectRule.ruleArn(), hostname, pathWithLeadingSlash, query)).orElseGet(() -> this.insertAndReturnDefaultRedirectRule(hostname, pathWithLeadingSlash, query));
    }

    private Rule insertAndReturnDefaultRedirectRule(String hostname, String pathWithLeadingSlash, Optional<String> query) {
        Rule defaultRedirectRule = this.createDefaultRedirectRule(hostname, pathWithLeadingSlash, query);
        this.addRulesAssigningUnusedPriorities(false, Util.stream(this.getRules()).filter(rule -> rule.conditions().stream().anyMatch(condition -> condition.field().equals("host-header") && condition.hostHeaderConfig().values().contains(hostname))).findFirst(), defaultRedirectRule);
        return defaultRedirectRule;
    }

    @Override
    public Rule getDefaultRedirectRule(String hostName, PlainRedirectDTO redirect) {
        Rule defaultRedirectRule = this.createDefaultRedirectRule(hostName, redirect.getPath(), redirect.getQuery());
        return defaultRedirectRule;
    }

    private Rule createDefaultRedirectRule(String hostname, String pathWithLeadingSlash, Optional<String> query) {
        return (Rule)this.getDefaultRedirectRuleBuilder(hostname, pathWithLeadingSlash, query).build();
    }

    private Rule.Builder getDefaultRedirectRuleBuilder(String hostname, String pathWithLeadingSlash, Optional<String> query) {
        return Rule.builder().conditions(new RuleCondition[]{(RuleCondition)RuleCondition.builder().field("path-pattern").pathPatternConfig(ppc -> {
            PathPatternConditionConfig.Builder builder = ppc.values(new String[]{"/"});
        }).build(), this.createHostHeaderRuleCondition(hostname)}).actions(new Action[]{this.createDefaultRedirectAction(pathWithLeadingSlash, query)});
    }

    private Action createDefaultRedirectAction(String pathWithLeadingSlash, Optional<String> query) {
        RedirectActionConfig.Builder redirectConfigBuilder = RedirectActionConfig.builder().protocol("#{protocol}").port("#{port}").host("#{host}").path(pathWithLeadingSlash).statusCode(RedirectActionStatusCodeEnum.HTTP_302);
        query.ifPresent(q -> {
            RedirectActionConfig.Builder builder2 = redirectConfigBuilder.query(q);
        });
        return (Action)Action.builder().type(ActionTypeEnum.REDIRECT).redirectConfig((RedirectActionConfig)redirectConfigBuilder.build()).build();
    }

    @Override
    public RuleCondition createHostHeaderRuleCondition(String hostname) {
        return (RuleCondition)RuleCondition.builder().field("host-header").hostHeaderConfig(hhcb -> {
            HostHeaderConditionConfig.Builder builder = hhcb.values(new String[]{hostname});
        }).build();
    }

    private Rule updateDefaultRedirectRule(String defaultRedirectRuleArn, String hostname, String pathWithLeadingSlash, Optional<String> query) {
        Rule updatedRule = (Rule)this.getDefaultRedirectRuleBuilder(hostname, pathWithLeadingSlash, query).ruleArn(defaultRedirectRuleArn).build();
        this.landscape.updateLoadBalancerListenerRule(this.getRegion(), updatedRule);
        return updatedRule;
    }

    private boolean isDefaultRedirectRule(Rule rule, String hostname) {
        return rule.conditions().stream().filter(condition -> condition.field().equals("host-header") && condition.hostHeaderConfig().values().contains(hostname)).findAny().isPresent() && rule.conditions().stream().filter(condition -> condition.field().equals("path-pattern") && condition.pathPatternConfig().values().size() == 1 && condition.pathPatternConfig().values().contains("/")).findAny().isPresent();
    }

    @Override
    public Iterable<Rule> getRulesForTargetGroups(Iterable<TargetGroup<ShardingKey>> targetGroups) {
        ArrayList<Rule> ret = new ArrayList<Rule>();
        for (Rule rule : this.getRules()) {
            for (Action action : rule.actions()) {
                if (action.type() != ActionTypeEnum.FORWARD) continue;
                for (String arn : Util.map((Iterable)action.forwardConfig().targetGroups(), s -> s.targetGroupArn())) {
                    for (String targetArn : Util.map(targetGroups, s -> s.getTargetGroupArn())) {
                        if (!arn.equals(targetArn)) continue;
                        ret.add(rule);
                    }
                }
            }
        }
        return ret;
    }

    @Override
    public Iterable<Rule> replaceTargetGroupInForwardRules(TargetGroup<ShardingKey> oldTargetGroup, TargetGroup<ShardingKey> newTargetGroup) {
        Iterable<Rule> rules = this.getRules();
        ArrayList<Rule> modifiedRules = new ArrayList<Rule>();
        for (Rule r : rules) {
            int i = 0;
            boolean modified = false;
            Action[] newActions = new Action[r.actions().size()];
            for (Action a : r.actions()) {
                if (a.forwardConfig() != null && a.targetGroupArn().equals(oldTargetGroup.getTargetGroupArn())) {
                    newActions[i++] = this.createForwardToTargetGroupAction(newTargetGroup);
                    modified = true;
                    continue;
                }
                newActions[i++] = a;
            }
            if (!modified) continue;
            this.landscape.modifyRuleActions(this.region, (Rule)Rule.builder().actions(newActions).ruleArn(r.ruleArn()).build()).forEach(t -> {
                boolean bl = modifiedRules.add((Rule)t);
            });
        }
        return modifiedRules;
    }

    private Action createForwardToTargetGroupAction(TargetGroup<ShardingKey> targetGroup) {
        return (Action)Action.builder().type(ActionTypeEnum.FORWARD).forwardConfig(fc -> {
            ForwardActionConfig.Builder builder = fc.targetGroups(new TargetGroupTuple[]{(TargetGroupTuple)TargetGroupTuple.builder().targetGroupArn(targetGroup.getTargetGroupArn()).build()});
        }).build();
    }
}

