/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.concurrent.ConsumerWithException;
import com.sap.sse.landscape.Landscape;
import com.sap.sse.landscape.Log;
import com.sap.sse.landscape.MachineImage;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.RotatingFileBasedLog;
import com.sap.sse.landscape.SecurityGroup;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.application.Scope;
import com.sap.sse.landscape.aws.ApplicationLoadBalancer;
import com.sap.sse.landscape.aws.AwsAvailabilityZone;
import com.sap.sse.landscape.aws.AwsInstance;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.ReverseProxyCluster;
import com.sap.sse.landscape.aws.Tags;
import com.sap.sse.landscape.aws.TargetGroup;
import com.sap.sse.landscape.aws.impl.AbstractApacheReverseProxy;
import com.sap.sse.landscape.aws.impl.ApacheReverseProxy;
import com.sap.sse.landscape.aws.impl.AwsInstanceImpl;
import com.sap.sse.shared.util.Wait;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.awssdk.services.ec2.model.InstanceStateName;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TagDescription;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealth;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthStateEnum;

public class ApacheReverseProxyCluster<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>, LogT extends Log>
extends AbstractApacheReverseProxy<ShardingKey, MetricsT, ProcessT>
implements ReverseProxyCluster<ShardingKey, MetricsT, ProcessT, RotatingFileBasedLog> {
    private static final Logger logger = Logger.getLogger(ApacheReverseProxyCluster.class.getName());
    private Set<AwsInstance<ShardingKey>> hosts = new HashSet<AwsInstance<ShardingKey>>();

    public ApacheReverseProxyCluster(AwsLandscape<ShardingKey> landscape) {
        super(landscape);
    }

    @Override
    public Iterable<AwsInstance<ShardingKey>> getHosts() {
        return Collections.unmodifiableCollection(this.hosts);
    }

    private Iterable<ApacheReverseProxy<ShardingKey, MetricsT, ProcessT>> getReverseProxies() {
        return Util.map(this.hosts, host -> new ApacheReverseProxy(this.getLandscape(), host));
    }

    @Override
    public void addHost(AwsInstance<ShardingKey> host) {
        this.hosts.add(host);
    }

    @Override
    public AwsInstance<ShardingKey> createHost(String name, InstanceType instanceType, AwsAvailabilityZone az, String keyName) throws TimeoutException, Exception {
        AwsInstanceImpl host = this.getLandscape().launchHost((instanceId, availabilityZone, privateIpAddress, launchTimePoint, landscape) -> new AwsInstanceImpl(instanceId, availabilityZone, privateIpAddress, launchTimePoint, landscape), this.getAmiId(az.getRegion()), instanceType, az, keyName, this.getSecurityGroups(az.getRegion()), Optional.of(Tags.with("Name", name).and("DisposableProxy", "").and("ReverseProxy", "")), "");
        this.addHost(host);
        Wait.wait(() -> host.getInstance().state().name().equals((Object)InstanceStateName.RUNNING), result -> result, (boolean)true, Optional.of(Duration.ofSeconds((double)420.0)), (Duration)Duration.ofSeconds((double)30.0), (Level)Level.INFO, (String)"Is instance in the running state check");
        for (TargetGroup targetGroup : this.getLandscape().getTargetGroups(az.getRegion())) {
            targetGroup.getTagDescriptions().forEach(description -> description.tags().forEach(tag -> {
                if (tag.key().equals("allReverseProxies")) {
                    ApplicationLoadBalancer loadBalancer = targetGroup.getLoadBalancer();
                    if (loadBalancer != null && loadBalancer.getArn().contains("loadbalancer/net")) {
                        this.getLandscape().addIpTargetToTargetGroup(targetGroup, Collections.singleton(host));
                        logger.info("Added " + host.getPrivateAddress().getHostAddress() + " to NLB target group" + targetGroup.getTargetGroupArn());
                    } else if (loadBalancer != null) {
                        targetGroup.addTarget(host);
                        logger.info("Added " + host.getInstanceId() + " to target group" + targetGroup.getTargetGroupArn());
                    }
                }
            }));
        }
        return host;
    }

    @Override
    public void removeHost(AwsInstance<ShardingKey> host, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        assert (Util.contains(this.getHosts(), host));
        if (Util.size(this.getHosts()) == 1) {
            throw new IllegalStateException("Trying to remove the last hosts of reverse proxy " + this + ". Use terminate() instead");
        }
        AwsInstanceImpl instanceFromHost = new AwsInstanceImpl(host.getInstanceId(), host.getAvailabilityZone(), host.getPrivateAddress(Landscape.WAIT_FOR_PROCESS_TIMEOUT), host.getLaunchTimePoint(), this.getLandscape());
        ArrayList targetGroupsHostResidesIn = new ArrayList();
        for (TargetGroup targetGroup : this.getLandscape().getTargetGroups(host.getAvailabilityZone().getRegion())) {
            String loadBalancerArn = targetGroup.getLoadBalancerArn();
            if (loadBalancerArn == null) continue;
            for (TagDescription tagDescription : targetGroup.getTagDescriptions()) {
                if (!tagDescription.hasTags()) continue;
                tagDescription.tags().forEach(tag -> {
                    if (tag.key().equals("allReverseProxies") && targetGroup.getRegisteredTargets().containsKey(instanceFromHost)) {
                        targetGroupsHostResidesIn.add(targetGroup);
                        if (loadBalancerArn.contains("loadbalancer/net")) {
                            this.getLandscape().removeIpTargetFromTargetGroup(targetGroup, Collections.singleton(instanceFromHost));
                        } else {
                            targetGroup.removeTarget(instanceFromHost);
                        }
                    }
                });
            }
        }
        Wait.wait(() -> {
            for (TargetGroup tg : targetGroupsHostResidesIn) {
                TargetHealth targetHealth = tg.getRegisteredTargets().get(instanceFromHost);
                if (targetHealth == null || !targetHealth.state().equals((Object)TargetHealthStateEnum.DRAINING)) continue;
                return false;
            }
            return true;
        }, Optional.of(Duration.ofSeconds((double)600.0)), (Duration)Duration.ofSeconds((double)20.0), (Level)Level.INFO, (String)"Waiting for target to drain");
        ApacheReverseProxy proxy = new ApacheReverseProxy(this.getLandscape(), host);
        proxy.rotateLogs(optionalKeyName, privateKeyEncryptionPassphrase);
        this.getLandscape().terminate(host);
    }

    private Iterable<SecurityGroup> getSecurityGroups(Region region) {
        return this.getLandscape().getDefaultSecurityGroupsForReverseProxy(region);
    }

    private MachineImage getAmiId(Region region) {
        return this.getLandscape().getLatestImageWithType(region, "disposable-reverse-proxy");
    }

    @Override
    public void terminate() {
        HashSet hosts = new HashSet();
        Util.addAll(this.getHosts(), hosts);
        for (AwsInstance host : hosts) {
            this.getLandscape().terminate(host);
        }
    }

    private void setRedirect(ConsumerWithException<ApacheReverseProxy<ShardingKey, MetricsT, ProcessT>> redirectSetter) throws Exception {
        if (this.getReverseProxies().iterator().hasNext()) {
            ApacheReverseProxy<ShardingKey, MetricsT, ProcessT> proxy = this.getReverseProxies().iterator().next();
            redirectSetter.accept(proxy);
        }
    }

    @Override
    public void setPlainRedirect(String hostname, ProcessT applicationProcess, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.setRedirect(proxy -> proxy.setPlainRedirect(hostname, applicationProcess, optionalKeyName, privateKeyEncryptionPassphrase));
    }

    @Override
    public void setHomeRedirect(String hostname, ProcessT applicationProcess, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.setRedirect(proxy -> proxy.setHomeRedirect(hostname, applicationProcess, optionalKeyName, privateKeyEncryptionPassphrase));
    }

    @Override
    public void setEventRedirect(String hostname, ProcessT applicationProcess, UUID eventId, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.setRedirect(proxy -> proxy.setEventRedirect(hostname, applicationProcess, eventId, optionalKeyName, privateKeyEncryptionPassphrase));
    }

    @Override
    public void setEventSeriesRedirect(String hostname, ProcessT applicationProcess, UUID leaderboardGroupId, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.setRedirect(proxy -> proxy.setEventSeriesRedirect(hostname, applicationProcess, leaderboardGroupId, optionalKeyName, privateKeyEncryptionPassphrase));
    }

    @Override
    public void setEventArchiveRedirect(String hostname, UUID eventId, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.setRedirect(proxy -> proxy.setEventArchiveRedirect(hostname, eventId, optionalKeyName, privateKeyEncryptionPassphrase));
    }

    @Override
    public void setEventSeriesArchiveRedirect(String hostname, UUID leaderboardGroupId, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.setRedirect(proxy -> proxy.setEventSeriesArchiveRedirect(hostname, leaderboardGroupId, optionalKeyName, privateKeyEncryptionPassphrase));
    }

    @Override
    public void setHomeArchiveRedirect(String hostname, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.setRedirect(proxy -> proxy.setHomeArchiveRedirect(hostname, optionalKeyName, privateKeyEncryptionPassphrase));
    }

    @Override
    public void setScopeRedirect(Scope<ShardingKey> scope, ProcessT applicationProcess) throws Exception {
        this.setRedirect(proxy -> proxy.setScopeRedirect(scope, applicationProcess));
    }

    @Override
    public void removeRedirect(String hostname, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.setRedirect(proxy -> proxy.removeRedirect(hostname, optionalKeyName, privateKeyEncryptionPassphrase));
    }

    @Override
    public void removeRedirect(Scope<ShardingKey> scope, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        this.setRedirect(proxy -> proxy.removeRedirect(scope, optionalKeyName, privateKeyEncryptionPassphrase));
    }
}

