/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws;

import com.sap.sse.common.Named;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.aws.ApplicationLoadBalancer;
import com.sap.sse.landscape.aws.AwsInstance;
import com.sap.sse.landscape.aws.common.shared.TargetGroupConstants;
import java.util.Collections;
import java.util.Map;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TagDescription;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealth;

public interface TargetGroup<ShardingKey>
extends Named,
TargetGroupConstants {
    public Region getRegion();

    public Map<AwsInstance<ShardingKey>, TargetHealth> getRegisteredTargets();

    default public void addTarget(AwsInstance<ShardingKey> target) {
        this.addTargets(Collections.singleton(target));
    }

    public void addTargets(Iterable<AwsInstance<ShardingKey>> var1);

    default public void removeTarget(AwsInstance<ShardingKey> target) {
        this.removeTargets(Collections.singleton(target));
    }

    public void removeTargets(Iterable<AwsInstance<ShardingKey>> var1);

    public Integer getPort();

    public Iterable<TagDescription> getTagDescriptions();

    public ProtocolEnum getProtocol();

    public Integer getHealthCheckPort();

    public String getHealthCheckPath();

    public ProtocolEnum getHealthCheckProtocol();

    public String getTargetGroupArn();

    default public String getId() {
        return this.getTargetGroupArn().substring(this.getTargetGroupArn().lastIndexOf(47) + 1);
    }

    public ApplicationLoadBalancer<ShardingKey> getLoadBalancer();

    public String getLoadBalancerArn();
}

