/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws;

import com.sap.sse.common.Util;
import com.sap.sse.landscape.Host;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.aws.AwsInstance;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.impl.AwsInstanceImpl;
import com.sap.sse.landscape.mongodb.Database;
import com.sap.sse.landscape.mongodb.MongoEndpoint;
import com.sap.sse.landscape.mongodb.MongoProcessInReplicaSet;
import com.sap.sse.landscape.mongodb.MongoReplicaSet;
import com.sap.sse.landscape.mongodb.impl.MongoProcessImpl;
import com.sap.sse.landscape.mongodb.impl.MongoProcessInReplicaSetImpl;
import com.sap.sse.landscape.mongodb.impl.MongoReplicaSetImpl;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class MongoUriParser<ShardingKey> {
    private static final String SCHEME = "mongodb";
    private final AwsLandscape<ShardingKey> landscape;
    private final Region region;

    public MongoUriParser(AwsLandscape<ShardingKey> landscape, Region region) {
        this.landscape = landscape;
        this.region = region;
    }

    public Database parseMongoUri(String mongoUri) throws URISyntaxException, UnknownHostException {
        MongoEndpoint endpoint;
        int n;
        URI mongoUriAsUri = new URI(mongoUri);
        if (!Util.equalsWithNull((Object)SCHEME, (Object)mongoUriAsUri.getScheme())) {
            throw new IllegalArgumentException("Expected scheme mongodb");
        }
        String[] hostnamesAndOptionalPorts = mongoUriAsUri.getAuthority().split(",");
        String dbName = mongoUriAsUri.getPath().replaceAll("^/", "");
        if (!Util.hasLength((String)dbName)) {
            throw new IllegalArgumentException("Expected non-empty database name");
        }
        String query = mongoUriAsUri.getQuery();
        String replicaSetName = null;
        if (query != null) {
            String[] stringArray = query.split("&");
            n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String keyValuePair = stringArray[n2];
                String[] keyAndValue = keyValuePair.split("=", 2);
                if (Util.equalsWithNull((Object)keyAndValue[0], (Object)"replicaSet")) {
                    replicaSetName = keyAndValue[1];
                }
                ++n2;
            }
        }
        if (replicaSetName != null) {
            MongoReplicaSetImpl replicaSet = new MongoReplicaSetImpl(replicaSetName);
            String[] stringArray = hostnamesAndOptionalPorts;
            int n3 = hostnamesAndOptionalPorts.length;
            n = 0;
            while (n < n3) {
                String hostnameAndOptionalPort = stringArray[n];
                MongoProcessInReplicaSet mongoProcessInReplicaSet = this.getMongoProcessInReplicaSet((MongoReplicaSet)replicaSet, hostnameAndOptionalPort);
                if (mongoProcessInReplicaSet != null) {
                    replicaSet.addReplica(mongoProcessInReplicaSet);
                }
                ++n;
            }
            endpoint = replicaSet;
        } else {
            endpoint = this.getMongoProcess(hostnamesAndOptionalPorts[0]);
        }
        return endpoint == null ? null : endpoint.getDatabase(dbName);
    }

    public Database parseMongoDBConfigurationFromStatus(JSONObject mongoDBConfigurationJSON) throws UnknownHostException {
        MongoEndpoint endpoint;
        String databaseName = mongoDBConfigurationJSON.get((Object)"database").toString();
        String replicaSetName = mongoDBConfigurationJSON.get((Object)"replicaSet").toString();
        ArrayList<Util.Pair<AwsInstance<ShardingKey>, Integer>> hostnamesAndPorts = new ArrayList<Util.Pair<AwsInstance<ShardingKey>, Integer>>();
        JSONArray serversJSON = (JSONArray)mongoDBConfigurationJSON.get((Object)"servers");
        for (Object serverObject : serversJSON) {
            JSONObject serverJSON = (JSONObject)serverObject;
            String hostname = serverJSON.get((Object)"host").toString();
            int port = ((Number)serverJSON.get((Object)"port")).intValue();
            hostnamesAndPorts.add(this.getHostAndPort(hostname, port));
        }
        if (replicaSetName != null) {
            MongoReplicaSetImpl replicaSet = new MongoReplicaSetImpl(replicaSetName);
            for (Util.Pair pair : hostnamesAndPorts) {
                MongoProcessInReplicaSet mongoProcessInReplicaSet = this.getMongoProcessInReplicaSet((MongoReplicaSet)replicaSet, pair);
                if (mongoProcessInReplicaSet == null) continue;
                replicaSet.addReplica(mongoProcessInReplicaSet);
            }
            endpoint = replicaSet;
        } else {
            endpoint = this.getMongoProcess((Util.Pair)hostnamesAndPorts.get(0));
        }
        return endpoint == null ? null : endpoint.getDatabase(databaseName);
    }

    private MongoEndpoint getMongoProcess(String hostnameAndOptionalPort) throws UnknownHostException {
        Util.Pair<AwsInstance<ShardingKey>, Integer> hostAndOptionalPort = this.getHostAndPort(hostnameAndOptionalPort);
        return this.getMongoProcess(hostAndOptionalPort);
    }

    private MongoEndpoint getMongoProcess(Util.Pair<AwsInstance<ShardingKey>, Integer> hostAndOptionalPort) {
        MongoProcessImpl endpoint = hostAndOptionalPort.getA() != null ? (hostAndOptionalPort.getB() != null ? new MongoProcessImpl((Host)hostAndOptionalPort.getA(), ((Integer)hostAndOptionalPort.getB()).intValue()) : new MongoProcessImpl((Host)hostAndOptionalPort.getA())) : null;
        return endpoint;
    }

    private MongoProcessInReplicaSet getMongoProcessInReplicaSet(MongoReplicaSet replicaSet, String hostnameAndOptionalPort) throws UnknownHostException {
        Util.Pair<AwsInstance<ShardingKey>, Integer> hostAndOptionalPort = this.getHostAndPort(hostnameAndOptionalPort);
        return this.getMongoProcessInReplicaSet(replicaSet, hostAndOptionalPort);
    }

    private MongoProcessInReplicaSet getMongoProcessInReplicaSet(MongoReplicaSet replicaSet, Util.Pair<AwsInstance<ShardingKey>, Integer> hostAndOptionalPort) {
        MongoProcessInReplicaSetImpl endpoint = hostAndOptionalPort.getA() != null ? (hostAndOptionalPort.getB() != null ? new MongoProcessInReplicaSetImpl(replicaSet, ((Integer)hostAndOptionalPort.getB()).intValue(), (Host)hostAndOptionalPort.getA()) : new MongoProcessInReplicaSetImpl(replicaSet, (Host)hostAndOptionalPort.getA())) : null;
        return endpoint;
    }

    private Util.Pair<AwsInstance<ShardingKey>, Integer> getHostAndPort(String hostnameAndOptionalPort) throws UnknownHostException {
        String[] hostnameAndOptionalPortSplit = hostnameAndOptionalPort.split(":");
        String hostname = hostnameAndOptionalPortSplit[0];
        Integer port = hostnameAndOptionalPortSplit.length < 2 ? null : Integer.valueOf(hostnameAndOptionalPortSplit[1]);
        return this.getHostAndPort(hostname, port);
    }

    private Util.Pair<AwsInstance<ShardingKey>, Integer> getHostAndPort(String hostname, Integer optionalPort) throws UnknownHostException {
        InetAddress address = InetAddress.getByName(hostname);
        AwsInstanceImpl hostByPrivateIp = this.landscape.getHostByPrivateIpAddress(this.region, address.getHostAddress(), AwsInstanceImpl::new);
        return new Util.Pair((Object)hostByPrivateIp, (Object)optionalPort);
    }
}

