/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.Host;
import com.sap.sse.landscape.Landscape;
import com.sap.sse.landscape.MachineImage;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.Release;
import com.sap.sse.landscape.RotatingFileBasedLog;
import com.sap.sse.landscape.SecurityGroup;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.aws.AmazonMachineImage;
import com.sap.sse.landscape.aws.ApplicationLoadBalancer;
import com.sap.sse.landscape.aws.ApplicationProcessHost;
import com.sap.sse.landscape.aws.AwsApplicationProcess;
import com.sap.sse.landscape.aws.AwsApplicationReplicaSet;
import com.sap.sse.landscape.aws.AwsAutoScalingGroup;
import com.sap.sse.landscape.aws.AwsAvailabilityZone;
import com.sap.sse.landscape.aws.AwsInstance;
import com.sap.sse.landscape.aws.HostSupplier;
import com.sap.sse.landscape.aws.ReverseProxyCluster;
import com.sap.sse.landscape.aws.Tags;
import com.sap.sse.landscape.aws.TargetGroup;
import com.sap.sse.landscape.aws.impl.Activator;
import com.sap.sse.landscape.aws.impl.AwsInstanceImpl;
import com.sap.sse.landscape.aws.impl.AwsLandscapeImpl;
import com.sap.sse.landscape.aws.impl.AwsRegion;
import com.sap.sse.landscape.aws.impl.AwsTargetGroupImpl;
import com.sap.sse.landscape.aws.impl.DNSCache;
import com.sap.sse.landscape.aws.orchestration.AwsApplicationConfiguration;
import com.sap.sse.landscape.mongodb.Database;
import com.sap.sse.landscape.mongodb.MongoEndpoint;
import com.sap.sse.landscape.mongodb.MongoReplicaSet;
import com.sap.sse.landscape.mongodb.impl.MongoProcessImpl;
import com.sap.sse.landscape.ssh.SSHKeyPair;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingGroup;
import software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupResponse;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.KeyPairInfo;
import software.amazon.awssdk.services.ec2.model.LaunchTemplate;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateVersion;
import software.amazon.awssdk.services.ec2.model.Snapshot;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Listener;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerState;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityPair;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TagDescription;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealth;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthDescription;
import software.amazon.awssdk.services.route53.model.ChangeInfo;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;
import software.amazon.awssdk.services.sts.model.Credentials;

public interface AwsLandscape<ShardingKey>
extends Landscape<ShardingKey> {
    public static final long DEFAULT_DNS_TTL_SECONDS = 60L;
    public static final String ACCESS_KEY_ID_SYSTEM_PROPERTY_NAME = "com.sap.sse.landscape.aws.accesskeyid";
    public static final String SECRET_ACCESS_KEY_SYSTEM_PROPERTY_NAME = "com.sap.sse.landscape.aws.secretaccesskey";
    public static final String MFA_TOKEN_CODE_SYSTEM_PROPERTY_NAME = "com.sap.sse.landscape.aws.mfatokencode";
    public static final String SESSION_TOKEN_SYSTEM_PROPERTY_NAME = "com.sap.sse.landscape.aws.sessiontoken";
    public static final String MONGO_REPLICA_SETS_TAG_NAME = "mongo-replica-sets";
    public static final String MONGO_DEFAULT_REPLICA_SET_NAME = "live";
    public static final String MONGO_REPLICA_SET_NAME_AND_PORT_SEPARATOR = ":";

    public static <ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>> AwsLandscape<ShardingKey> obtain(String pathPrefixForShardingKey) {
        AwsLandscapeImpl result = new AwsLandscapeImpl(Activator.getInstance().getLandscapeState(), pathPrefixForShardingKey);
        return result;
    }

    public static <ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>> AwsLandscape<ShardingKey> obtain(String accessKey, String secret, String pathPrefixForShardingKey) {
        AwsLandscapeImpl result = new AwsLandscapeImpl(Activator.getInstance().getLandscapeState(), accessKey, secret, pathPrefixForShardingKey);
        return result;
    }

    public static <ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>> AwsLandscape<ShardingKey> obtain(String accessKey, String secret, String sessionToken, String pathPrefixForShardingKey) {
        AwsLandscapeImpl result = new AwsLandscapeImpl(Activator.getInstance().getLandscapeState(), accessKey, secret, sessionToken, pathPrefixForShardingKey);
        return result;
    }

    default public AwsInstance<ShardingKey> launchHost(MachineImage image, InstanceType instanceType, AwsAvailabilityZone availabilityZone, String keyName, Iterable<SecurityGroup> securityGroups, Optional<Tags> tags, String ... userData) {
        HostSupplier hostSupplier = (instanceId, az, privateIpAddress, launchTimePoint, landscape) -> new AwsInstanceImpl(instanceId, az, privateIpAddress, launchTimePoint, landscape);
        return this.launchHost(hostSupplier, image, instanceType, availabilityZone, keyName, securityGroups, tags, userData);
    }

    default public <HostT extends AwsInstance<ShardingKey>> HostT launchHost(HostSupplier<ShardingKey, HostT> hostSupplier, MachineImage fromImage, InstanceType instanceType, AwsAvailabilityZone az, String keyName, Iterable<SecurityGroup> securityGroups, Optional<Tags> tags, String ... userData) {
        return (HostT)((AwsInstance)this.launchHosts(hostSupplier, 1, fromImage, instanceType, az, keyName, securityGroups, tags, userData).iterator().next());
    }

    public <HostT extends AwsInstance<ShardingKey>> Iterable<HostT> launchHosts(HostSupplier<ShardingKey, HostT> var1, int var2, MachineImage var3, InstanceType var4, AwsAvailabilityZone var5, String var6, Iterable<SecurityGroup> var7, Optional<Tags> var8, String ... var9);

    public AmazonMachineImage<ShardingKey> getImage(Region var1, String var2);

    public AmazonMachineImage<ShardingKey> createImage(AwsInstance<ShardingKey> var1, String var2, Optional<Tags> var3);

    public void deleteImage(Region var1, String var2);

    public AmazonMachineImage<ShardingKey> getLatestImageWithTag(Region var1, String var2, String var3);

    default public AmazonMachineImage<ShardingKey> getLatestImageWithType(Region region, String imageType) {
        return this.getLatestImageWithTag(region, "image-type", imageType);
    }

    public Iterable<AmazonMachineImage<ShardingKey>> getAllImagesWithTag(Region var1, String var2, String var3);

    default public Iterable<AmazonMachineImage<ShardingKey>> getAllImagesWithType(Region region, String imageType) {
        return this.getAllImagesWithTag(region, "image-type", imageType);
    }

    public Iterable<String> getMachineImageTypes(Region var1);

    public void setSnapshotName(Region var1, String var2, String var3);

    public void deleteSnapshot(Region var1, String var2);

    public <HostT extends AwsInstance<ShardingKey>> Iterable<HostT> getHostsWithTagValue(Region var1, String var2, String var3, HostSupplier<ShardingKey, HostT> var4);

    public <HostT extends AwsInstance<ShardingKey>> Iterable<HostT> getHostsWithTag(Region var1, String var2, HostSupplier<ShardingKey, HostT> var3);

    public <HostT extends AwsInstance<ShardingKey>> HostT getHostByInstanceId(Region var1, String var2, HostSupplier<ShardingKey, HostT> var3);

    public <HostT extends AwsInstance<ShardingKey>> Iterable<HostT> getRunningHostsWithTag(Region var1, String var2, HostSupplier<ShardingKey, HostT> var3);

    public <HostT extends AwsInstance<ShardingKey>> HostT getHostByPrivateIpAddress(Region var1, String var2, HostSupplier<ShardingKey, HostT> var3);

    public <HostT extends AwsInstance<ShardingKey>> HostT getHostByPublicIpAddress(Region var1, String var2, HostSupplier<ShardingKey, HostT> var3);

    public <HostT extends AwsInstance<ShardingKey>> Iterable<HostT> getRunningHostsWithTagValue(Region var1, String var2, String var3, HostSupplier<ShardingKey, HostT> var4);

    public KeyPairInfo getKeyPairInfo(Region var1, String var2);

    public Iterable<KeyPairInfo> getAllKeyPairInfos(Region var1);

    public void deleteKeyPair(Region var1, String var2);

    public SSHKeyPair importKeyPair(Region var1, byte[] var2, byte[] var3, String var4) throws JSchException;

    public void terminate(AwsInstance<ShardingKey> var1);

    public SSHKeyPair getSSHKeyPair(Region var1, String var2);

    public Iterable<SSHKeyPair> getSSHKeyPairs();

    public SSHKeyPair addSSHKeyPair(Region var1, String var2, String var3, KeyPair var4) throws JSchException;

    public SSHKeyPair createKeyPair(Region var1, String var2, byte[] var3) throws JSchException;

    public Instance getInstance(String var1, Region var2);

    public Instance getInstanceByPublicIpAddress(Region var1, String var2);

    public Instance getInstanceByPrivateIpAddress(Region var1, String var2);

    public ChangeInfo setDNSRecordToHost(String var1, String var2, Host var3, boolean var4);

    public ChangeInfo setDNSRecordToApplicationLoadBalancer(String var1, String var2, ApplicationLoadBalancer<ShardingKey> var3, boolean var4);

    public String getDNSHostedZoneId(String var1);

    public static String removeTrailingDotFromHostname(String hostname) {
        return hostname.replaceFirst("\\.$", "");
    }

    public ChangeInfo setDNSRecordToValue(String var1, String var2, String var3, boolean var4);

    public ChangeInfo removeDNSRecord(String var1, String var2, RRType var3, String var4);

    public ChangeInfo removeDNSRecord(String var1, String var2, String var3);

    public ChangeInfo getUpdatedChangeInfo(ChangeInfo var1);

    public Iterable<ApplicationLoadBalancer<ShardingKey>> getLoadBalancers(Region var1);

    public CompletableFuture<Map<TargetGroup<ShardingKey>, Iterable<TargetHealthDescription>>> getTargetGroupsAsync(Region var1);

    public Iterable<TargetGroup<ShardingKey>> getTargetGroups(Region var1);

    public CompletableFuture<Iterable<TargetHealthDescription>> getTargetHealthDescriptionsAsync(Region var1, TargetGroup<ShardingKey> var2);

    public CompletableFuture<Map<Listener, Iterable<Rule>>> getLoadBalancerListenerRulesAsync(Region var1, CompletableFuture<Iterable<ApplicationLoadBalancer<ShardingKey>>> var2);

    public CompletableFuture<Iterable<ApplicationLoadBalancer<ShardingKey>>> getLoadBalancersAsync(Region var1);

    public ApplicationLoadBalancer<ShardingKey> getLoadBalancer(String var1, Region var2);

    public ApplicationLoadBalancer<ShardingKey> getLoadBalancerByName(String var1, Region var2);

    public ApplicationLoadBalancer<ShardingKey> createLoadBalancer(String var1, Region var2, SecurityGroup var3) throws InterruptedException, ExecutionException;

    public Iterable<Listener> getListeners(ApplicationLoadBalancer<ShardingKey> var1);

    public CompletableFuture<Listener> getHttpsListenerAsync(Region var1, ApplicationLoadBalancer<ShardingKey> var2);

    public LoadBalancerState getApplicationLoadBalancerStatus(ApplicationLoadBalancer<ShardingKey> var1);

    public Iterable<AwsAvailabilityZone> getAvailabilityZones(Region var1);

    public AwsAvailabilityZone getAvailabilityZoneByName(Region var1, String var2);

    public void deleteLoadBalancer(ApplicationLoadBalancer<ShardingKey> var1);

    public Iterable<TargetGroup<ShardingKey>> getTargetGroupsByLoadBalancerArn(Region var1, String var2);

    public TargetGroup<ShardingKey> getTargetGroup(Region var1, String var2);

    public TargetGroup<ShardingKey> getTargetGroup(Region var1, String var2, String var3);

    public TargetGroup<ShardingKey> createTargetGroup(Region var1, String var2, int var3, String var4, int var5, String var6, String var7);

    public TargetGroup<ShardingKey> copyTargetGroup(TargetGroup<ShardingKey> var1, String var2);

    default public TargetGroup<ShardingKey> getTargetGroup(Region region, String targetGroupName, String targetGroupArn, String loadBalancerArn, ProtocolEnum protocol, Integer port, ProtocolEnum healthCheckProtocol, Integer healthCheckPort, String healthCheckPath) {
        return new AwsTargetGroupImpl(this, region, targetGroupName, targetGroupArn, loadBalancerArn, protocol, port, healthCheckProtocol, healthCheckPort, healthCheckPath);
    }

    public software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup getAwsTargetGroup(Region var1, String var2);

    public software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup getAwsTargetGroupByArn(Region var1, String var2);

    public Map<AwsInstance<ShardingKey>, TargetHealth> getTargetHealthDescriptions(TargetGroup<ShardingKey> var1);

    public <SK> void deleteTargetGroup(TargetGroup<SK> var1);

    public Iterable<Rule> getLoadBalancerListenerRules(Listener var1, Region var2);

    public Iterable<Rule> modifyRuleConditions(Region var1, Rule var2);

    public Iterable<Rule> modifyRuleActions(Region var1, Rule var2);

    public Iterable<Rule> createLoadBalancerListenerRules(Region var1, Listener var2, Rule ... var3);

    public void deleteLoadBalancerListenerRules(Region var1, Rule ... var2);

    public void updateLoadBalancerListenerRule(Region var1, Rule var2);

    public void updateLoadBalancerListenerRulePriorities(Region var1, Iterable<RulePriorityPair> var2);

    public void deleteLoadBalancerListener(Region var1, Listener var2);

    public SecurityGroup getSecurityGroup(String var1, Region var2);

    public Optional<SecurityGroup> getSecurityGroupByName(String var1, Region var2);

    public void addTargetsToTargetGroup(TargetGroup<ShardingKey> var1, Iterable<AwsInstance<ShardingKey>> var2);

    public void removeTargetsFromTargetGroup(TargetGroup<ShardingKey> var1, Iterable<AwsInstance<ShardingKey>> var2);

    public LoadBalancer getAwsLoadBalancer(String var1, Region var2);

    public <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>> ReverseProxyCluster<ShardingKey, MetricsT, ProcessT, RotatingFileBasedLog> getReverseProxyCluster(Region var1);

    public <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>> ReverseProxyCluster<ShardingKey, MetricsT, ProcessT, RotatingFileBasedLog> getCentralReverseProxy(Region var1);

    public ApplicationLoadBalancer<ShardingKey> getNonDNSMappedLoadBalancer(Region var1, String var2);

    public ApplicationLoadBalancer<ShardingKey> createNonDNSMappedLoadBalancer(Region var1, String var2, SecurityGroup var3) throws InterruptedException, ExecutionException;

    public ApplicationLoadBalancer<ShardingKey> getDNSMappedLoadBalancerFor(Region var1, String var2);

    public ApplicationLoadBalancer<ShardingKey> getDNSMappedLoadBalancerFor(String var1);

    public MongoEndpoint getDatabaseConfigurationForDefaultReplicaSet(Region var1);

    public Tags getTagForMongoProcess(Tags var1, String var2, int var3);

    public MongoReplicaSet getDatabaseConfigurationForReplicaSet(Region var1, String var2);

    public MongoReplicaSet getDatabaseConfigurationForReplicaSet(String var1, Iterable<Util.Pair<AwsInstance<ShardingKey>, Integer>> var2);

    public MongoProcessImpl getDatabaseConfigurationForSingleNode(AwsInstance<ShardingKey> var1, int var2);

    public Iterable<MongoEndpoint> getMongoEndpoints(Region var1);

    public Database getDatabase(Region var1, String var2);

    public AwsRegion getDefaultRegion();

    public Optional<String> getTag(AwsInstance<ShardingKey> var1, String var2);

    public <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>, HostT extends ApplicationProcessHost<ShardingKey, MetricsT, ProcessT>> Iterable<HostT> getApplicationProcessHostsByTag(Region var1, String var2, HostSupplier<ShardingKey, HostT> var3);

    public <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>, HostT extends ApplicationProcessHost<ShardingKey, MetricsT, ProcessT>> Iterable<AwsApplicationReplicaSet<ShardingKey, MetricsT, ProcessT>> getApplicationReplicaSetsByTag(Region var1, String var2, HostSupplier<ShardingKey, HostT> var3, Optional<Duration> var4, Optional<String> var5, byte[] var6) throws Exception;

    public <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>, HostT extends ApplicationProcessHost<ShardingKey, MetricsT, ProcessT>> AwsApplicationReplicaSet<ShardingKey, MetricsT, ProcessT> getApplicationReplicaSetByTagValue(Region var1, String var2, String var3, HostSupplier<ShardingKey, HostT> var4, Optional<Duration> var5, Optional<String> var6, byte[] var7) throws Exception;

    public Credentials getMfaSessionCredentials(String var1);

    public <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>> void createLaunchTemplateAndAutoScalingGroup(Region var1, String var2, Optional<Tags> var3, TargetGroup<ShardingKey> var4, String var5, InstanceType var6, String var7, AwsApplicationConfiguration<ShardingKey, MetricsT, ProcessT> var8, int var9, int var10, int var11);

    public Snapshot getSnapshot(AwsRegion var1, String var2);

    public ApplicationLoadBalancer<ShardingKey> getLoadBalancerByHostname(String var1);

    public static String getHostedZoneName(String hostname) {
        return hostname.substring(hostname.indexOf(46) + 1);
    }

    public CompletableFuture<Iterable<ResourceRecordSet>> getResourceRecordSetsAsync(String var1);

    public String findHostnamesForIP(String var1);

    public Iterable<ResourceRecordSet> getResourceRecordSets(String var1);

    public DNSCache getNewDNSCache();

    public CompletableFuture<Iterable<AutoScalingGroup>> getAutoScalingGroupsAsync(Region var1);

    public CompletableFuture<Iterable<LaunchTemplate>> getLaunchTemplatesAsync(Region var1);

    public CompletableFuture<Iterable<LaunchTemplateVersion>> getLaunchTemplateDefaultVersionsAsync(Region var1);

    public <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>> AwsApplicationReplicaSet<ShardingKey, MetricsT, ProcessT> getApplicationReplicaSet(Region var1, String var2, ProcessT var3, Iterable<ProcessT> var4, Optional<Duration> var5, Optional<String> var6, byte[] var7) throws InterruptedException, ExecutionException, TimeoutException;

    public CompletableFuture<Void> removeAutoScalingGroupAndLaunchTemplate(AwsAutoScalingGroup var1);

    public CompletableFuture<DeleteAutoScalingGroupResponse> removeAutoScalingGroup(AwsAutoScalingGroup var1);

    public void updateAutoScalingGroupMinSize(AwsAutoScalingGroup var1, int var2);

    public void updateReleaseInAutoScalingGroups(Region var1, LaunchTemplate var2, Iterable<AwsAutoScalingGroup> var3, String var4, Release var5);

    public void updateImageInAutoScalingGroups(Region var1, Iterable<AwsAutoScalingGroup> var2, String var3, AmazonMachineImage<ShardingKey> var4);

    public void updateInstanceTypeInAutoScalingGroup(Region var1, Iterable<AwsAutoScalingGroup> var2, String var3, InstanceType var4);

    public TargetGroup<ShardingKey> createTargetGroupWithoutLoadbalancer(Region var1, String var2, int var3, String var4);

    public <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>> String createAutoScalingGroupFromExisting(AwsAutoScalingGroup var1, String var2, TargetGroup<ShardingKey> var3, int var4, Optional<Tags> var5);

    public void resetShardMinAutoscalingGroupSize(String var1, Region var2);

    public <MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>> void putScalingPolicy(int var1, String var2, TargetGroup<ShardingKey> var3, int var4, Region var5);

    public Iterable<TagDescription> getTargetGroupTags(String var1, Region var2);

    public Tags addTargetGroupTag(String var1, String var2, String var3, Region var4);

    public String getAutoScalingGroupName(String var1);

    public AwsCredentials getCredentials();

    public Iterable<AwsAvailabilityZone> getAvailabilityZones(Region var1, Optional<String> var2);

    public void addIpTargetToTargetGroup(TargetGroup<ShardingKey> var1, Iterable<AwsInstance<ShardingKey>> var2);

    public void removeIpTargetFromTargetGroup(TargetGroup<ShardingKey> var1, Iterable<AwsInstance<ShardingKey>> var2);
}

