/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws;

import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.application.ApplicationReplicaSet;
import com.sap.sse.landscape.aws.ApplicationLoadBalancer;
import com.sap.sse.landscape.aws.AwsAutoScalingGroup;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.AwsShard;
import com.sap.sse.landscape.aws.TargetGroup;
import com.sap.sse.landscape.aws.common.shared.ShardTargetGroupName;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;

public interface AwsApplicationReplicaSet<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
extends ApplicationReplicaSet<ShardingKey, MetricsT, ProcessT> {
    public ApplicationLoadBalancer<ShardingKey> getLoadBalancer() throws InterruptedException, ExecutionException;

    public TargetGroup<ShardingKey> getMasterTargetGroup() throws InterruptedException, ExecutionException;

    public TargetGroup<ShardingKey> getPublicTargetGroup() throws InterruptedException, ExecutionException;

    public Iterable<TargetGroup<ShardingKey>> getOtherTargetGroups() throws InterruptedException, ExecutionException;

    public String getHostedZoneId() throws InterruptedException, ExecutionException;

    public ResourceRecordSet getResourceRecordSet() throws InterruptedException, ExecutionException;

    public Iterable<Rule> getLoadBalancerRules() throws InterruptedException, ExecutionException;

    public Rule getDefaultRedirectRule() throws InterruptedException, ExecutionException;

    public AwsAutoScalingGroup getAutoScalingGroup() throws InterruptedException, ExecutionException;

    default public Iterable<AwsAutoScalingGroup> getAllAutoScalingGroups() throws InterruptedException, ExecutionException {
        HashSet<AwsAutoScalingGroup> result = new HashSet<AwsAutoScalingGroup>();
        if (this.getAutoScalingGroup() != null) {
            result.add(this.getAutoScalingGroup());
        }
        Util.addAll((Iterable)Util.map(this.getShards().keySet(), shard -> shard.getAutoScalingGroup()), result);
        return result;
    }

    public void stopAllUnmanagedReplicas(Optional<Duration> var1, Optional<String> var2, byte[] var3) throws Exception;

    default public int getPort() throws InterruptedException, ExecutionException {
        int port = this.getMaster() != null ? this.getMaster().getPort() : this.getMasterTargetGroup().getPort().intValue();
        return port;
    }

    public void restartAllReplicas(Optional<Duration> var1, Optional<String> var2, byte[] var3) throws Exception;

    public boolean isLocalReplicaSet();

    public ShardTargetGroupName getNewShardName(String var1, String var2) throws Exception;

    public Map<AwsShard<ShardingKey>, Iterable<ShardingKey>> getShards();

    public void removeShard(AwsShard<ShardingKey> var1, AwsLandscape<ShardingKey> var2) throws Exception;
}

