/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws;

import com.sap.sse.common.Named;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.TargetGroup;
import com.sap.sse.landscape.aws.common.shared.PlainRedirectDTO;
import com.sap.sse.landscape.aws.common.shared.RedirectDTO;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Listener;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;

public interface ApplicationLoadBalancer<ShardingKey>
extends Named {
    public static final int MAX_RULES_PER_LOADBALANCER = 100;
    public static final String DNS_MAPPED_ALB_NAME_PREFIX = "DNSMapped-";
    public static final Pattern ALB_NAME_PATTERN = Pattern.compile("DNSMapped-(.*)$");
    public static final int MAX_ALBS_PER_REGION = 20;
    public static final int MAX_CONDITIONS_PER_RULE = 5;
    public static final String DEFAULT_RULE_PRIORITY = "Default";
    public static final int MAX_PRIORITY = 50000;

    public AwsLandscape<ShardingKey> getLandscape();

    public String getDNSName();

    public Iterable<Rule> getRules();

    public void deleteRules(Rule ... var1);

    public Region getRegion();

    public String getArn();

    public String getVpcId();

    public List<String> getSecurityGroupIds();

    default public String getId() {
        return this.getArn().substring(this.getArn().lastIndexOf(47) + 1);
    }

    public Iterable<Rule> addRules(Rule ... var1);

    public Iterable<Rule> addRulesAssigningUnusedPriorities(boolean var1, Optional<Rule> var2, Rule ... var3);

    public int getFirstShardingPriority(String var1) throws IllegalStateException;

    public Iterable<TargetGroup<ShardingKey>> getTargetGroups();

    public void delete() throws InterruptedException;

    public void deleteListener(Listener var1);

    public Listener getListener(ProtocolEnum var1);

    default public Rule setDefaultRedirect(String hostname, RedirectDTO redirect) {
        return this.setDefaultRedirect(hostname, redirect.getPath(), redirect.getQuery());
    }

    public Rule setDefaultRedirect(String var1, String var2, Optional<String> var3);

    public Rule getDefaultRedirectRule(String var1, PlainRedirectDTO var2);

    public RuleCondition createHostHeaderRuleCondition(String var1);

    public Iterable<Rule> getRulesForTargetGroups(Iterable<TargetGroup<ShardingKey>> var1);

    public Iterable<Rule> replaceTargetGroupInForwardRules(TargetGroup<ShardingKey> var1, TargetGroup<ShardingKey> var2);
}

