/*
 * Decompiled with CFR 0.152.
 */
package com.tractrac.subscription.app.tracapi;

import com.tractrac.model.lib.api.data.IPosition;
import com.tractrac.model.lib.api.event.IRaceCompetitor;
import com.tractrac.model.lib.api.map.IPositionedItem;
import com.tractrac.subscription.app.tracapi.AbstractListener;
import com.tractrac.util.lib.api.TimeUtils;
import java.util.Date;

public class DelayListener
extends AbstractListener {
    @Override
    public void gotPositionedItemPosition(IPositionedItem control, IPosition position) {
    }

    @Override
    public void gotPosition(IRaceCompetitor raceCompetitor, IPosition position) {
        if (!raceCompetitor.getCompetitor().isNonCompeting()) {
            this.printDelay(position.getTimestamp(), raceCompetitor.getCompetitor().getName());
        }
    }

    private void printDelay(long sampleTime, String name) {
        long now = new Date().getTime();
        long diff = now - sampleTime;
        int steps = Math.round(diff / 100L);
        StringBuilder delay = new StringBuilder();
        int i = 0;
        while (i < steps) {
            delay.append("*");
            ++i;
        }
        System.out.println(String.valueOf(TimeUtils.formatDateInMillis((long)now)) + ": " + TimeUtils.formatDateInMillis((long)sampleTime) + ": " + this.fillString(name, 25) + "-> " + delay);
    }

    public String fillString(String string, int count) {
        if (string.length() > count) {
            return string.substring(0, count);
        }
        String out = string;
        int i = string.length();
        while (i < count) {
            out = String.valueOf(out) + "-";
            ++i;
        }
        return out;
    }
}

