/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.tracking.impl;

import com.sap.sailing.domain.common.AbstractPosition;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.tracking.impl.AbstractCompactWindImpl;
import com.sap.sailing.domain.common.tracking.impl.CompactPositionHelper;
import com.sap.sailing.domain.common.tracking.impl.CompactionNotPossibleException;
import com.sap.sse.common.AbstractBearing;
import com.sap.sse.common.Bearing;

public class VeryCompactWindImpl
extends AbstractCompactWindImpl {
    private static final long serialVersionUID = -5059956032663387929L;
    private final int latDegScaled;
    private final int lngDegScaled;
    private final short speedInKnotsScaled;
    private final short degreeBearingScaled;

    public VeryCompactWindImpl(Wind wind) throws CompactionNotPossibleException {
        super(wind);
        this.degreeBearingScaled = wind.getBearing() == null ? (short)0 : CompactPositionHelper.getDegreeBearingScaled(wind.getBearing());
        if (wind.getPosition() == null) {
            this.latDegScaled = 0;
            this.lngDegScaled = 0;
        } else {
            this.latDegScaled = CompactPositionHelper.getLatDegScaled(wind.getPosition());
            this.lngDegScaled = CompactPositionHelper.getLngDegScaled(wind.getPosition());
        }
        this.speedInKnotsScaled = CompactPositionHelper.getKnotSpeedScaled(wind);
    }

    @Override
    public double getKnots() {
        return CompactPositionHelper.getKnotSpeed(this.speedInKnotsScaled);
    }

    @Override
    protected Position getCompactPosition() {
        return new VeryCompactPosition();
    }

    @Override
    protected Bearing getCompactBearing() {
        return new VeryCompactBearing();
    }

    private class VeryCompactBearing
    extends AbstractBearing {
        private static final long serialVersionUID = -6474909210513108635L;

        private VeryCompactBearing() {
        }

        public double getDegrees() {
            return CompactPositionHelper.getDegreeBearing(VeryCompactWindImpl.this.degreeBearingScaled);
        }
    }

    public class VeryCompactPosition
    extends AbstractPosition {
        private static final long serialVersionUID = 5621506820766614178L;

        @Override
        public double getLatDeg() {
            return CompactPositionHelper.getLatDeg(VeryCompactWindImpl.this.latDegScaled);
        }

        @Override
        public double getLngDeg() {
            return CompactPositionHelper.getLngDeg(VeryCompactWindImpl.this.lngDegScaled);
        }
    }
}

