/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.tracking.impl;

import com.sap.sailing.domain.common.AbstractPosition;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.AbstractSpeedWithAbstractBearingImpl;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.impl.AbstractCompactGPSFixMovingImpl;
import com.sap.sse.common.AbstractBearing;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;

public class PreciseCompactGPSFixMovingImpl
extends AbstractCompactGPSFixMovingImpl {
    private static final long serialVersionUID = 761582024504236533L;
    private final double latDeg;
    private final double lngDeg;
    private final double knotSpeed;
    private final double degBearing;
    private final double trueHeadingDeg;
    private final boolean trueHeadingDegSet;
    private double cachedEstimatedSpeedBearingInDegrees;
    private double cachedEstimatedSpeedInKnots;

    public PreciseCompactGPSFixMovingImpl(Position position, TimePoint timePoint, SpeedWithBearing speed, Bearing optionalTrueHeading) {
        super(timePoint);
        this.latDeg = position.getLatDeg();
        this.lngDeg = position.getLngDeg();
        this.knotSpeed = speed == null ? 0.0 : speed.getKnots();
        double d = this.degBearing = speed == null ? 0.0 : speed.getBearing().getDegrees();
        if (optionalTrueHeading == null) {
            this.trueHeadingDegSet = false;
            this.trueHeadingDeg = 0.0;
        } else {
            this.trueHeadingDegSet = true;
            this.trueHeadingDeg = optionalTrueHeading.getDegrees();
        }
    }

    public PreciseCompactGPSFixMovingImpl(GPSFixMoving gpsFixMoving) {
        this(gpsFixMoving.getPosition(), gpsFixMoving.getTimePoint(), gpsFixMoving.getSpeed(), gpsFixMoving.getOptionalTrueHeading());
    }

    @Override
    public SpeedWithBearing getSpeed() {
        return new PreciseCompactSpeedWithBearing();
    }

    @Override
    public Position getPosition() {
        return new PreciseCompactPosition();
    }

    @Override
    public Bearing getOptionalTrueHeading() {
        return this.trueHeadingDegSet ? new PreciseCompactTrueHeading() : null;
    }

    @Override
    public SpeedWithBearing getCachedEstimatedSpeed() {
        assert (this.isEstimatedSpeedCached());
        return new PreciseCompactEstimatedSpeed();
    }

    @Override
    public void cacheEstimatedSpeed(SpeedWithBearing estimatedSpeed) {
        this.cachedEstimatedSpeedBearingInDegrees = estimatedSpeed.getBearing().getDegrees();
        this.cachedEstimatedSpeedInKnots = estimatedSpeed.getKnots();
        super.cacheEstimatedSpeed(estimatedSpeed);
    }

    private class PreciseCompactBearing
    extends AbstractBearing {
        private static final long serialVersionUID = -6474909210513108635L;

        private PreciseCompactBearing() {
        }

        public double getDegrees() {
            return PreciseCompactGPSFixMovingImpl.this.degBearing;
        }
    }

    public class PreciseCompactEstimatedSpeed
    extends AbstractSpeedWithAbstractBearingImpl {
        private static final long serialVersionUID = -5871855443391817248L;

        @Override
        public Bearing getBearing() {
            return new PreciseCompactEstimatedSpeedBearing();
        }

        @Override
        public double getKnots() {
            return PreciseCompactGPSFixMovingImpl.this.cachedEstimatedSpeedInKnots;
        }
    }

    private class PreciseCompactEstimatedSpeedBearing
    extends AbstractBearing {
        private static final long serialVersionUID = 8549231429037883121L;

        private PreciseCompactEstimatedSpeedBearing() {
        }

        public double getDegrees() {
            return PreciseCompactGPSFixMovingImpl.this.cachedEstimatedSpeedBearingInDegrees;
        }
    }

    public class PreciseCompactPosition
    extends AbstractPosition {
        private static final long serialVersionUID = 5621506820766614178L;

        @Override
        public double getLatDeg() {
            return PreciseCompactGPSFixMovingImpl.this.latDeg;
        }

        @Override
        public double getLngDeg() {
            return PreciseCompactGPSFixMovingImpl.this.lngDeg;
        }
    }

    public class PreciseCompactSpeedWithBearing
    extends AbstractCompactGPSFixMovingImpl.AbstractCompactSpeedWithBearing
    implements SpeedWithBearing {
        private static final long serialVersionUID = 1802065090733146728L;

        @Override
        public double getKnots() {
            return PreciseCompactGPSFixMovingImpl.this.knotSpeed;
        }

        @Override
        public Bearing getBearing() {
            return new PreciseCompactBearing();
        }
    }

    private class PreciseCompactTrueHeading
    extends AbstractBearing {
        private static final long serialVersionUID = -1837422977159746992L;

        private PreciseCompactTrueHeading() {
        }

        public double getDegrees() {
            return PreciseCompactGPSFixMovingImpl.this.trueHeadingDeg;
        }
    }
}

