/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.scalablevalue.impl;

import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sse.common.Distance;
import com.sap.sse.common.scalablevalue.ScalableValue;
import com.sap.sse.common.scalablevalue.ScalableValueWithDistance;

public class ScalableDistance
implements ScalableValueWithDistance<Double, Distance> {
    private final double meters;

    public ScalableDistance(Distance distance) {
        this.meters = distance.getMeters();
    }

    private ScalableDistance(double meters) {
        this.meters = meters;
    }

    public ScalableDistance multiply(double factor) {
        return new ScalableDistance(factor * this.meters);
    }

    public ScalableDistance add(ScalableValue<Double, Distance> t) {
        return new ScalableDistance(this.meters + (Double)t.getValue());
    }

    public Distance divide(double divisor) {
        return new MeterDistance(this.meters / divisor);
    }

    public Double getValue() {
        return this.meters;
    }

    public double getDistance(Distance other) {
        return Math.abs(this.meters - other.getMeters());
    }
}

