/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.quadtree.impl;

import com.sap.sailing.domain.common.Bounds;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.BoundsImpl;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.quadtree.QuadTree;
import com.sap.sse.common.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Node<T> {
    public static int visitedItems;
    public static int visitedNodes;
    public static int skippedNodes;
    private Node<T>[] children;
    private Map<Position, T> items;
    private final Bounds bounds;
    private final int maxItems;
    private final int NE = 0;
    private final int NW = 1;
    private final int SW = 2;
    private final int SE = 3;

    public Node(Bounds bounds, int maxItems) {
        if (bounds.getNorthEast().getLatDeg() < bounds.getSouthEast().getLatDeg()) {
            throw new IllegalArgumentException("North border of bounds " + bounds + " is further south than its south border");
        }
        if (maxItems <= 0) {
            throw new IllegalArgumentException("Maximum number of items must be positive but was " + maxItems);
        }
        this.maxItems = maxItems;
        this.bounds = bounds;
        this.items = new HashMap<Position, T>(maxItems);
    }

    private void split() {
        assert (this.children == null);
        assert (this.items != null);
        this.createChildren();
        this.distributeItemsToChildren();
        assert (this.children != null);
        assert (this.items == null);
    }

    private void distributeItemsToChildren() {
        assert (this.items != null);
        assert (this.children != null);
        Map<Position, T> myItems = this.items;
        this.items = null;
        for (Map.Entry<Position, T> item : myItems.entrySet()) {
            this.getChild(item.getKey()).put(item.getKey(), item.getValue());
        }
        assert (this.items == null);
    }

    private Node<T> getChild(Position key) {
        assert (this.children != null);
        assert (this.items == null);
        assert (this.bounds.contains(key));
        Node<T>[] nodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            Node<T> child = nodeArray[n2];
            if (child.bounds.contains(key)) {
                return child;
            }
            ++n2;
        }
        throw new RuntimeException("Internal error: position " + key + " is within node bounds " + this.bounds + " but no child contains it");
    }

    public T put(Position key, T value) {
        T result;
        if (value == null) {
            throw new NullPointerException("Cannot insert null values into this node");
        }
        if (key == null) {
            throw new NullPointerException("null keys not allowed");
        }
        if (!this.bounds.contains(key)) {
            throw new IllegalArgumentException("key " + key + " must be within this node's bounds " + this.bounds);
        }
        if (this.items != null) {
            result = this.items.put(key, value);
            if (result == null && this.items.size() > this.maxItems) {
                this.split();
            }
        } else {
            result = this.getChild(key).put(key, value);
        }
        return result;
    }

    public T remove(Position key) {
        T result = key != null ? (this.items != null ? (T)this.items.remove(key) : (T)this.getChild(key).remove(key)) : null;
        return result;
    }

    private void createChildren() {
        assert (this.children == null);
        Node[] newChildren = new Node[4];
        this.children = newChildren;
        DegreePosition middleWest = new DegreePosition((this.bounds.getSouthWest().getLatDeg() + this.bounds.getNorthEast().getLatDeg()) / 2.0, this.bounds.getSouthWest().getLngDeg());
        DegreePosition southCenter = new DegreePosition(this.bounds.getSouthWest().getLatDeg(), (this.bounds.getNorthEast().getLngDeg() + this.bounds.getSouthWest().getLngDeg()) / 2.0 - (this.bounds.getNorthEast().getLngDeg() >= this.bounds.getSouthWest().getLngDeg() ? 0.0 : 360.0));
        DegreePosition middleCenter = new DegreePosition(middleWest.getLatDeg(), southCenter.getLngDeg());
        DegreePosition middleEast = new DegreePosition(middleWest.getLatDeg(), this.bounds.getNorthEast().getLngDeg());
        DegreePosition northCenter = new DegreePosition(this.bounds.getNorthEast().getLatDeg(), southCenter.getLngDeg());
        this.children[0] = new Node<T>(new BoundsImpl(middleCenter, this.bounds.getNorthEast()), this.maxItems);
        this.children[1] = new Node<T>(new BoundsImpl(middleWest, northCenter), this.maxItems);
        this.children[2] = new Node<T>(new BoundsImpl(this.bounds.getSouthWest(), middleCenter), this.maxItems);
        this.children[3] = new Node<T>(new BoundsImpl(southCenter, middleEast), this.maxItems);
        assert (this.children != null);
        assert (this.children.length == 4);
        assert (this.children[0] != null && this.children[1] != null && this.children[2] != null && this.children[3] != null);
    }

    public void clear() {
        if (this.items != null) {
            this.items.clear();
        } else {
            this.items = new HashMap<Position, T>();
            this.children = null;
        }
    }

    public GetResult<T> get(Position point, double withinDistance) {
        assert (this.items == null != (this.children == null));
        ++visitedNodes;
        GetResult<T> result = null;
        double minDistance = withinDistance;
        if (this.items != null) {
            for (Map.Entry<Position, T> item : this.items.entrySet()) {
                double itemDistanceToPoint = QuadTree.getLatLngDistance(point, item.getKey());
                ++visitedItems;
                if (!(itemDistanceToPoint < minDistance)) continue;
                result = new GetResult<T>(item.getKey(), item.getValue(), itemDistanceToPoint);
                minDistance = itemDistanceToPoint;
            }
        } else {
            double[] childDistanceToPoint = new double[4];
            double minChildDistanceToPoint = Double.MAX_VALUE;
            int i = 0;
            while (i < 4) {
                childDistanceToPoint[i] = this.children[i].getDistance(point);
                if (childDistanceToPoint[i] < minChildDistanceToPoint) {
                    minChildDistanceToPoint = childDistanceToPoint[i];
                }
                ++i;
            }
            boolean[] done = new boolean[4];
            int doneCount = 0;
            while (doneCount < 4) {
                double nextMinChildDistanceToPoint = Double.MAX_VALUE;
                int i2 = 0;
                while (doneCount < 4 && i2 < 4) {
                    if (!done[i2]) {
                        if (childDistanceToPoint[i2] == minChildDistanceToPoint) {
                            Node<T> child = this.children[i2];
                            if (!super.isEmptyLeaf() && childDistanceToPoint[i2] < minDistance) {
                                assert (minDistance <= withinDistance);
                                GetResult<T> childResult = child.get(point, minDistance);
                                if (childResult != null && childResult.getDistance() < minDistance) {
                                    result = childResult;
                                    minDistance = childResult.getDistance();
                                }
                            } else {
                                ++skippedNodes;
                            }
                            done[i2] = true;
                            ++doneCount;
                        } else if (childDistanceToPoint[i2] < nextMinChildDistanceToPoint) {
                            nextMinChildDistanceToPoint = childDistanceToPoint[i2];
                        }
                    }
                    ++i2;
                }
                minChildDistanceToPoint = nextMinChildDistanceToPoint;
            }
        }
        return result;
    }

    public GetResult<T> get(Position point) {
        return this.get(point, Double.MAX_VALUE);
    }

    private boolean isEmptyLeaf() {
        return this.items != null && this.items.isEmpty();
    }

    protected double getDistance(Position point) {
        double result;
        if (this.bounds.contains(point)) {
            result = 0.0;
        } else {
            Bounds boundsAtPointLatExtendedToIncludePoint;
            double latDegNearestOnBorder = point.getLatDeg() > this.bounds.getNorthEast().getLatDeg() ? this.bounds.getNorthEast().getLatDeg() : (point.getLatDeg() < this.bounds.getSouthWest().getLatDeg() ? this.bounds.getSouthWest().getLatDeg() : point.getLatDeg());
            BoundsImpl boundsAtPointLat = new BoundsImpl(new DegreePosition(point.getLatDeg(), this.bounds.getSouthWest().getLngDeg()), new DegreePosition(point.getLatDeg(), this.bounds.getNorthEast().getLngDeg()));
            double lngDegNearestOnBorder = boundsAtPointLat.contains(point) ? point.getLngDeg() : ((boundsAtPointLatExtendedToIncludePoint = boundsAtPointLat.extend(point)).getSouthWest().getLngDeg() == this.bounds.getSouthWest().getLngDeg() ? this.bounds.getNorthEast().getLngDeg() : this.bounds.getSouthWest().getLngDeg());
            result = QuadTree.getLatLngDistance(point, new DegreePosition(latDegNearestOnBorder, lngDegNearestOnBorder));
        }
        return result;
    }

    public Iterable<T> get(Bounds bounds) {
        Set result;
        if (this.bounds.intersects(bounds)) {
            HashSet preResult = new HashSet();
            if (this.items != null) {
                if (bounds.contains(this.bounds)) {
                    preResult.addAll(this.items.values());
                } else {
                    for (Map.Entry<Position, T> item : this.items.entrySet()) {
                        if (!bounds.contains(item.getKey())) continue;
                        preResult.add(item.getValue());
                    }
                }
            } else {
                Node<T>[] nodeArray = this.children;
                int n = this.children.length;
                int n2 = 0;
                while (n2 < n) {
                    Node<T> child = nodeArray[n2];
                    Util.addAll(child.get(bounds), preResult);
                    ++n2;
                }
            }
            result = preResult;
        } else {
            result = Collections.emptySet();
        }
        return result;
    }

    public String toString() {
        return this.bounds + ": " + (this.items == null ? 0 : this.items.size()) + " items in node, " + (this.children == null ? 0 : this.children.length) + " child nodes";
    }

    public static class GetResult<T> {
        private final Position position;
        private final T value;
        private final double distance;

        public GetResult(Position position, T value, double distance) {
            this.position = position;
            this.value = value;
            this.distance = distance;
        }

        public Position getPosition() {
            return this.position;
        }

        public T getValue() {
            return this.value;
        }

        public double getDistance() {
            return this.distance;
        }

        public String toString() {
            return "GetResult [position=" + this.position + ", value=" + this.value + ", distance=" + this.distance + "]";
        }
    }
}

