/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.orc.impl;

import com.sap.sailing.domain.common.orc.ORCCertificate;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.CountryCode;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.Collections;
import java.util.Map;

public class ORCCertificateImpl
implements ORCCertificate {
    private static final long serialVersionUID = 8725162998514202782L;
    private final String referenceNumber;
    private final String sailNumber;
    private final String boatName;
    private final String boatClassName;
    private final Distance lengthOverAll;
    private final Duration gph;
    private final Double cdl;
    private final TimePoint issueDate;
    private final String fileId;
    private final CountryCode issuingCountry;
    private final Map<Speed, Map<Bearing, Speed>> velocityPredictionPerTrueWindSpeedAndAngle;
    private final Map<Speed, Bearing> beatAngles;
    private final Map<Speed, Speed> beatVMGPredictionPerTrueWindSpeed;
    private final Map<Speed, Duration> beatAllowancePerTrueWindSpeed;
    private final Map<Speed, Bearing> runAngles;
    private final Map<Speed, Speed> runVMGPredictionPerTrueWindSpeed;
    private final Map<Speed, Duration> runAllowancePerTrueWindSpeed;
    private final Map<Speed, Speed> windwardLeewardSpeedPredictionPerTrueWindSpeed;
    private final Map<Speed, Speed> longDistanceSpeedPredictionPerTrueWindSpeed;
    private final Map<Speed, Speed> circularRandomSpeedPredictionPerTrueWindSpeed;
    private final Map<Speed, Speed> nonSpinnakerSpeedPredictionPerTrueWindSpeed;
    private final Speed[] allowancesTrueWindSpeeds;
    private final Bearing[] allowancesTrueWindAngles;

    public ORCCertificateImpl(Speed[] allowancesTrueWindSpeeds, Bearing[] allowancesTrueWindAngles, String referenceNumber, String fileId, String sailnumber, String boatName, String boatClassName, Distance length, Duration gph, Double cdl, TimePoint issueDate, CountryCode issuingCountry, Map<Speed, Map<Bearing, Speed>> velocityPredictionsPerTrueWindSpeedAndAngle, Map<Speed, Bearing> beatAngles, Map<Speed, Speed> beatVMGPredictionPerTrueWindSpeed, Map<Speed, Duration> beatAllowancePerTrueWindSpeed, Map<Speed, Bearing> runAngles, Map<Speed, Speed> runVMGPredictionPerTrueWindSpeed, Map<Speed, Duration> runAllowancePerTrueWindSpeed, Map<Speed, Speed> windwardLeewardSpeedPredictionsPerTrueWindSpeed, Map<Speed, Speed> longDistanceSpeedPredictionsPerTrueWindSpeed, Map<Speed, Speed> circularRandomSpeedPredictionsPerTrueWindSpeed, Map<Speed, Speed> nonSpinnakerSpeedPredictionsPerTrueWindSpeed) {
        this.allowancesTrueWindAngles = allowancesTrueWindAngles;
        this.allowancesTrueWindSpeeds = allowancesTrueWindSpeeds;
        this.referenceNumber = referenceNumber;
        this.fileId = fileId;
        this.issuingCountry = issuingCountry;
        this.sailNumber = sailnumber;
        this.boatName = boatName;
        this.boatClassName = boatClassName;
        this.lengthOverAll = length;
        this.gph = gph;
        this.cdl = cdl;
        this.issueDate = issueDate;
        this.velocityPredictionPerTrueWindSpeedAndAngle = Collections.unmodifiableMap(velocityPredictionsPerTrueWindSpeedAndAngle);
        this.beatAngles = Collections.unmodifiableMap(beatAngles);
        this.beatVMGPredictionPerTrueWindSpeed = Collections.unmodifiableMap(beatVMGPredictionPerTrueWindSpeed);
        this.beatAllowancePerTrueWindSpeed = Collections.unmodifiableMap(beatAllowancePerTrueWindSpeed);
        this.runAngles = Collections.unmodifiableMap(runAngles);
        this.runVMGPredictionPerTrueWindSpeed = Collections.unmodifiableMap(runVMGPredictionPerTrueWindSpeed);
        this.runAllowancePerTrueWindSpeed = Collections.unmodifiableMap(runAllowancePerTrueWindSpeed);
        this.windwardLeewardSpeedPredictionPerTrueWindSpeed = Collections.unmodifiableMap(windwardLeewardSpeedPredictionsPerTrueWindSpeed);
        this.longDistanceSpeedPredictionPerTrueWindSpeed = Collections.unmodifiableMap(longDistanceSpeedPredictionsPerTrueWindSpeed);
        this.circularRandomSpeedPredictionPerTrueWindSpeed = Collections.unmodifiableMap(circularRandomSpeedPredictionsPerTrueWindSpeed);
        this.nonSpinnakerSpeedPredictionPerTrueWindSpeed = Collections.unmodifiableMap(nonSpinnakerSpeedPredictionsPerTrueWindSpeed);
    }

    public ORCCertificateImpl(String referenceNumber, String fileId, String sailnumber, String boatName, String boatClassName, Distance length, Duration gph, Double cdl, TimePoint issueDate, CountryCode issuingCountry, Map<Speed, Map<Bearing, Speed>> velocityPredictionsPerTrueWindSpeedAndAngle, Map<Speed, Bearing> beatAngles, Map<Speed, Speed> beatVMGPredictionPerTrueWindSpeed, Map<Speed, Duration> beatAllowancePerTrueWindSpeed, Map<Speed, Bearing> runAngles, Map<Speed, Speed> runVMGPredictionPerTrueWindSpeed, Map<Speed, Duration> runAllowancePerTrueWindSpeed, Map<Speed, Speed> windwardLeewardSpeedPredictionsPerTrueWindSpeed, Map<Speed, Speed> longDistanceSpeedPredictionsPerTrueWindSpeed, Map<Speed, Speed> circularRandomSpeedPredictionsPerTrueWindSpeed, Map<Speed, Speed> nonSpinnakerSpeedPredictionsPerTrueWindSpeed) {
        this(ALLOWANCES_TRUE_WIND_SPEEDS, ALLOWANCES_TRUE_WIND_ANGLES, referenceNumber, fileId, sailnumber, boatName, boatClassName, length, gph, cdl, issueDate, issuingCountry, velocityPredictionsPerTrueWindSpeedAndAngle, beatAngles, beatVMGPredictionPerTrueWindSpeed, beatAllowancePerTrueWindSpeed, runAngles, runVMGPredictionPerTrueWindSpeed, runAllowancePerTrueWindSpeed, windwardLeewardSpeedPredictionsPerTrueWindSpeed, longDistanceSpeedPredictionsPerTrueWindSpeed, circularRandomSpeedPredictionsPerTrueWindSpeed, nonSpinnakerSpeedPredictionsPerTrueWindSpeed);
    }

    @Override
    public String getId() {
        return this.getReferenceNumber();
    }

    @Override
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    @Override
    public String getFileId() {
        return this.fileId;
    }

    @Override
    public CountryCode getIssuingCountry() {
        return this.issuingCountry;
    }

    @Override
    public String getBoatName() {
        return this.boatName;
    }

    @Override
    public Duration getGPH() {
        return this.gph;
    }

    @Override
    public double getGPHInSecondsToTheMile() {
        return this.gph == null ? 0.0 : this.gph.asSeconds();
    }

    @Override
    public Map<Speed, Speed> getWindwardLeewardSpeedPrediction() {
        return this.windwardLeewardSpeedPredictionPerTrueWindSpeed;
    }

    @Override
    public Map<Speed, Speed> getCircularRandomSpeedPredictions() {
        return this.circularRandomSpeedPredictionPerTrueWindSpeed;
    }

    @Override
    public Map<Speed, Speed> getLongDistanceSpeedPredictions() {
        return this.longDistanceSpeedPredictionPerTrueWindSpeed;
    }

    @Override
    public Map<Speed, Speed> getNonSpinnakerSpeedPredictions() {
        return this.nonSpinnakerSpeedPredictionPerTrueWindSpeed;
    }

    @Override
    public String getSailNumber() {
        return this.sailNumber;
    }

    @Override
    public String getBoatClassName() {
        return this.boatClassName;
    }

    @Override
    public Distance getLengthOverAll() {
        return this.lengthOverAll;
    }

    @Override
    public Double getCDL() {
        return this.cdl;
    }

    @Override
    public Map<Speed, Bearing> getBeatAngles() {
        return this.beatAngles;
    }

    @Override
    public Map<Speed, Bearing> getRunAngles() {
        return this.runAngles;
    }

    @Override
    public Map<Speed, Duration> getBeatAllowances() {
        return this.beatAllowancePerTrueWindSpeed;
    }

    @Override
    public Map<Speed, Duration> getRunAllowances() {
        return this.runAllowancePerTrueWindSpeed;
    }

    @Override
    public Map<Speed, Map<Bearing, Speed>> getVelocityPredictionPerTrueWindSpeedAndAngle() {
        return this.velocityPredictionPerTrueWindSpeedAndAngle;
    }

    @Override
    public Map<Speed, Speed> getBeatVMGPredictions() {
        return this.beatVMGPredictionPerTrueWindSpeed;
    }

    @Override
    public Map<Speed, Speed> getRunVMGPredictions() {
        return this.runVMGPredictionPerTrueWindSpeed;
    }

    @Override
    public TimePoint getIssueDate() {
        return this.issueDate;
    }

    public String toString() {
        return "Certificate with ID \"" + this.getId() + "\" for " + this.getSailNumber() + " / " + this.getBoatName() + " - Issued on: " + (this.getIssueDate() == null ? "n/a" : this.getIssueDate().asDate()) + " with GPH " + Util.padPositiveValue((double)this.getGPHInSecondsToTheMile(), (int)1, (int)1, (boolean)true);
    }

    @Override
    public Speed[] getTrueWindSpeeds() {
        return this.allowancesTrueWindSpeeds;
    }

    @Override
    public Bearing[] getTrueWindAngles() {
        return this.allowancesTrueWindAngles;
    }
}

