/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.media;

import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.media.MediaSubType;
import com.sap.sse.common.media.MimeType;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class MediaTrack
implements Serializable,
WithQualifiedObjectIdentifier {
    private static final long serialVersionUID = 1L;
    public String dbId;
    public String title;
    public String url;
    public TimePoint startTime;
    public Duration duration;
    public MimeType mimeType;
    public Set<RegattaAndRaceIdentifier> assignedRaces = new HashSet<RegattaAndRaceIdentifier>();

    public MediaTrack() {
    }

    public MediaTrack(String title, String url, TimePoint startTime, Duration duration, MimeType mimeType, Set<RegattaAndRaceIdentifier> assignedRaces) {
        this();
        this.title = title;
        this.url = url;
        this.startTime = startTime;
        this.duration = duration;
        this.mimeType = mimeType;
        if (assignedRaces != null) {
            this.assignedRaces.addAll(assignedRaces);
        }
    }

    public MediaTrack(String dbId, String title, String url, TimePoint startTime, Duration duration, MimeType mimeType, Set<RegattaAndRaceIdentifier> assignedRaces) {
        this(title, url, startTime, duration, mimeType, assignedRaces);
        this.dbId = dbId;
    }

    public String toString() {
        return String.valueOf(this.title) + " - " + this.url + " [" + this.typeToString() + ']' + " - " + this.assignedRaces + " - " + this.startTime + " [" + this.duration + ']';
    }

    public TimePoint deriveEndTime() {
        if (this.startTime != null && this.duration != null) {
            return this.startTime.plus(this.duration);
        }
        return null;
    }

    public String typeToString() {
        return this.mimeType == null ? "undefined" : this.mimeType.toString();
    }

    public boolean isYoutube() {
        return this.mimeType != null && MediaSubType.youtube.equals((Object)this.mimeType.mediaSubType);
    }

    public boolean overlapsWith(TimePoint startTime, TimePoint endTime) {
        if (this.startTime == null) {
            return false;
        }
        return !this.endsBefore(startTime != null ? startTime.asDate() : null) && !this.beginsAfter(endTime != null ? endTime.asDate() : null);
    }

    public boolean isConnectedTo(RegattaAndRaceIdentifier race) {
        return this.assignedRaces.contains(race);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MediaTrack) {
            MediaTrack mediaTrack = (MediaTrack)obj;
            return this.dbId == null ? mediaTrack.dbId == null : this.dbId.equals(mediaTrack.dbId);
        }
        return false;
    }

    public int hashCode() {
        return this.dbId == null ? 0 : this.dbId.hashCode();
    }

    public boolean beginsAfter(Date date) {
        return this.startTime != null && date != null && this.startTime.asDate().after(date);
    }

    public boolean endsBefore(Date date) {
        return date != null && this.deriveEndTime() != null && this.deriveEndTime().asDate().before(date);
    }

    public String getName() {
        return this.title;
    }

    public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    public HasPermissions getPermissionType() {
        return SecuredDomainType.MEDIA_TRACK;
    }

    public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return MediaTrack.getTypeRelativeObjectIdentifier(this.dbId);
    }

    public static TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier(String dbId) {
        return new TypeRelativeObjectIdentifier(new String[]{dbId});
    }

    @Deprecated
    public static enum Status {
        UNDEFINED('?'),
        CANNOT_PLAY('-'),
        NOT_REACHABLE('#'),
        REACHABLE('+');

        private final char symbol;

        private Status(char symbol) {
            this.symbol = symbol;
        }

        @Deprecated
        public String toString() {
            return String.valueOf(this.symbol);
        }
    }
}

