/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.impl;

import com.sap.sailing.domain.common.DataImportProgress;
import com.sap.sailing.domain.common.DataImportSubProgress;
import com.sap.sailing.domain.common.MasterDataImportObjectCreationCount;
import java.util.UUID;
import java.util.logging.Logger;

public class DataImportProgressImpl
implements DataImportProgress {
    private static final Logger logger = Logger.getLogger(DataImportProgressImpl.class.getName());
    private static final long serialVersionUID = 5538458397711003527L;
    private UUID currentImportOperationId;
    private MasterDataImportObjectCreationCount result = null;
    private double overallProgressPct = 0.0;
    private DataImportSubProgress currentSubProgress = DataImportSubProgress.IMPORT_INIT;
    private double currentSubProgressPct = 0.0;
    private boolean failed = false;
    private String errorMessage;

    @Deprecated
    DataImportProgressImpl() {
    }

    public DataImportProgressImpl(UUID currentImportOperationId) {
        this.currentImportOperationId = currentImportOperationId;
    }

    @Override
    public double getOverallProgressPct() {
        return this.overallProgressPct;
    }

    @Override
    public DataImportSubProgress getCurrentSubProgress() {
        return this.currentSubProgress;
    }

    @Override
    public double getCurrentSubProgressPct() {
        return this.currentSubProgressPct;
    }

    @Override
    public MasterDataImportObjectCreationCount getResult() {
        return this.result;
    }

    @Override
    public void setOverAllProgressPct(double pct) {
        this.overallProgressPct = pct;
    }

    @Override
    public void setCurrentSubProgress(DataImportSubProgress subProgress) {
        if (subProgress != this.currentSubProgress) {
            logger.info("Master data import with operation ID " + this.getOperationId() + " moving from stage " + (Object)((Object)this.currentSubProgress) + " to " + (Object)((Object)subProgress));
        }
        this.currentSubProgress = subProgress;
    }

    @Override
    public void setCurrentSubProgressPct(double pct) {
        this.currentSubProgressPct = pct;
    }

    @Override
    public void setResult(MasterDataImportObjectCreationCount result) {
        this.result = result;
    }

    @Override
    public UUID getOperationId() {
        return this.currentImportOperationId;
    }

    @Override
    public boolean failed() {
        return this.failed;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void setFailed() {
        this.failed = true;
    }

    @Override
    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }
}

