/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.impl;

import com.sap.sailing.domain.common.AbstractSpeedImpl;
import com.sap.sailing.domain.common.CourseChange;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.AbstractSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.CourseChangeImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.MeterPerSecondSpeedWithDegreeBearingImpl;
import com.sap.sailing.domain.common.impl.RadianBearingImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;

public abstract class AbstractSpeedWithAbstractBearingImpl
extends AbstractSpeedImpl
implements SpeedWithBearing {
    private static final long serialVersionUID = 6136100417593538013L;
    private static final TimePoint start = new MillisecondsTimePoint(0L);
    private static final TimePoint end = start.plus(60000L);

    @Override
    public Position travelTo(Position pos, TimePoint from, TimePoint to) {
        return pos.translateGreatCircle(this.getBearing(), this.travel(from, to));
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " to " + this.getBearing().getDegrees() + "\u00b0";
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.getBearing().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof SpeedWithBearing && this.getBearing().equals(((SpeedWithBearing)object).getBearing());
    }

    @Override
    public SpeedWithBearing add(SpeedWithBearing other) {
        return AbstractSpeedWithAbstractBearingImpl.add(this, other);
    }

    @Override
    public CourseChange getCourseChangeRequiredToReach(SpeedWithBearing targetSpeedWithBearing) {
        return AbstractSpeedWithBearingImpl.getCourseChangeRequiredToReach(this, targetSpeedWithBearing);
    }

    public static CourseChange getCourseChangeRequiredToReach(SpeedWithBearing from, SpeedWithBearing to) {
        double courseChangeInDegrees = to.getBearing().getDegrees() - from.getBearing().getDegrees();
        if (courseChangeInDegrees < -180.0) {
            courseChangeInDegrees += 360.0;
        } else if (courseChangeInDegrees > 180.0) {
            courseChangeInDegrees -= 360.0;
        }
        double speedChangeInKnots = to.getKnots() - from.getKnots();
        return new CourseChangeImpl(courseChangeInDegrees, speedChangeInKnots);
    }

    @Override
    public SpeedWithBearing applyCourseChange(CourseChange courseChange) {
        return AbstractSpeedWithAbstractBearingImpl.applyCourseChange(this, courseChange);
    }

    public static SpeedWithBearing applyCourseChange(SpeedWithBearing from, CourseChange courseChange) {
        double newBearingDeg = from.getBearing().getDegrees() + courseChange.getCourseChangeInDegrees();
        if (newBearingDeg < 0.0) {
            newBearingDeg += 360.0;
        } else if (newBearingDeg > 360.0) {
            newBearingDeg -= 360.0;
        }
        DegreeBearingImpl newBearing = new DegreeBearingImpl(newBearingDeg);
        double newSpeedInKnots = from.getKnots() + courseChange.getSpeedChangeInKnots();
        return new KnotSpeedWithBearingImpl(newSpeedInKnots, (Bearing)newBearing);
    }

    public static Speed projectTo(SpeedWithBearing speedWithBearing, Position position, Bearing projectTo) {
        Position traveledOneMinute = speedWithBearing.travelTo(position, start, end);
        Position traveledToProjected = traveledOneMinute.projectToLineThrough(position, projectTo);
        Distance projectedDistance = position.getDistance(traveledToProjected);
        return projectedDistance.inTime(end.asMillis() - start.asMillis());
    }

    @Override
    public Speed projectTo(Position position, Bearing projectTo) {
        return AbstractSpeedWithAbstractBearingImpl.projectTo(this, position, projectTo);
    }

    public static SpeedWithBearing add(SpeedWithBearing first, SpeedWithBearing other) {
        double x = first.getMetersPerSecond() * Math.cos(first.getBearing().getRadians()) + other.getMetersPerSecond() * Math.cos(other.getBearing().getRadians());
        double y = first.getMetersPerSecond() * Math.sin(first.getBearing().getRadians()) + other.getMetersPerSecond() * Math.sin(other.getBearing().getRadians());
        double metersPerSecond = Math.sqrt(x * x + y * y);
        double directionRad = (Math.PI * 2 + Math.atan2(y, x)) % (Math.PI * 2);
        return new MeterPerSecondSpeedWithDegreeBearingImpl(metersPerSecond, new RadianBearingImpl(directionRad));
    }

    @Override
    public SpeedWithBearing scale(double d) {
        return SpeedWithBearing.super.scale(d);
    }
}

