/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.dto;

import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.IncrementalOrFullLeaderboardDTO;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.dto.LeaderboardEntryDTO;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.domain.common.dto.LegEntryDTO;
import com.sap.sailing.domain.common.dto.PreviousCompetitorDTOImpl;
import com.sap.sailing.domain.common.dto.PreviousCompetitorWithBoatDTOImpl;
import com.sap.sailing.domain.common.dto.PreviousSuppressedCompetitorDTOImpl;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sse.common.Cloner;
import com.sap.sse.common.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IncrementalLeaderboardDTO
extends LeaderboardDTO
implements IncrementalOrFullLeaderboardDTO {
    private static final long serialVersionUID = -7011986430671280594L;
    private String isDiffToLeaderboardDTOWithId;
    private String updatedFromPreviousVersionWithId;
    private boolean commentUnchanged;
    private int[] competitorIndexesInPreviousCompetitorsList;
    private List<CompetitorDTO> addedCompetitors;
    private boolean suppressedCompetitorsUnchanged;
    private boolean competitorDisplayNamesUnchanged;
    private boolean regattaNameUnchanged;
    private boolean displayNameUnchanged;
    private boolean courseAreasUnchanged;
    private boolean boatClassUnchanged;
    private boolean aclUnchanged;
    private boolean ownershipUnchanged;
    private UnchangedWithCompetitorsInBitSet<String> unchangedLeaderboardEntries;
    private Set<String> raceColumnNamesForWhichCompetitorOrderingPerRaceUnchanged;
    private int[] indexOfUnchangedRaceColumnDTOsInPrevious;
    private transient Cloner cloner;
    private UnchangedLegDetails legDetailsUnchanged;
    private UnchangedWithCompetitorsInBitSet<Void> rowsUnchanged;
    private Date currentServerTime;

    @Deprecated
    IncrementalLeaderboardDTO() {
    }

    public IncrementalLeaderboardDTO(String id, Cloner cloner) {
        super(id, null);
        this.cloner = cloner;
    }

    @Override
    public LeaderboardDTO getLeaderboardDTO(LeaderboardDTO previousVersion) {
        if (previousVersion == null) {
            throw new IllegalArgumentException("Must provide a valid previous leaderboard version to reconstruct full LeaderboardDTO from differential leaderboard DTO");
        }
        this.applyThisToPreviousVersionByUpdatingThis(previousVersion);
        return this;
    }

    private void applyThisToPreviousVersionByUpdatingThis(LeaderboardDTO previousVersion) {
        HashMap<String, CompetitorDTO> competitorsOfPreviousVersionByIdAsString = new HashMap<String, CompetitorDTO>();
        for (CompetitorDTO c : previousVersion.competitors) {
            competitorsOfPreviousVersionByIdAsString.put(c.getIdAsString(), c);
        }
        if (this.updatedFromPreviousVersionWithId != null) {
            if (!this.updatedFromPreviousVersionWithId.equals(previousVersion.getId())) {
                throw new IllegalStateException("This incremental leaderboard DTO was already applied to a different previous version. It cannot be applied multiple times.");
            }
        } else {
            CompetitorDTO previousCompetitor;
            Map<Object, Object> map;
            if (!this.isDiffToLeaderboardDTOWithId.equals(previousVersion.getId())) {
                throw new IllegalArgumentException("Trying to apply leaderboard DTO diff to leaderboard DTO with ID " + previousVersion.getId() + " although the diff was meant to be applied to a leaderboard DTO with ID " + this.isDiffToLeaderboardDTOWithId);
            }
            this.updatedFromPreviousVersionWithId = previousVersion.getId();
            if (this.commentUnchanged) {
                this.setComment(previousVersion.getComment());
            }
            if (this.courseAreasUnchanged) {
                this.courseAreas = previousVersion.courseAreas;
            }
            if (this.displayNameUnchanged) {
                this.displayName = previousVersion.displayName;
            }
            if (this.regattaNameUnchanged) {
                this.regattaName = previousVersion.regattaName;
            }
            if (this.boatClassUnchanged) {
                this.setBoatClass(previousVersion.getBoatClass());
            }
            if (this.competitorIndexesInPreviousCompetitorsList != null) {
                this.competitors = new ArrayList(this.competitorIndexesInPreviousCompetitorsList.length);
                Iterator<CompetitorDTO> addedCompetitorsIter = null;
                int i = 0;
                while (i < this.competitorIndexesInPreviousCompetitorsList.length) {
                    if (this.competitorIndexesInPreviousCompetitorsList[i] == -1) {
                        if (addedCompetitorsIter == null) {
                            addedCompetitorsIter = this.addedCompetitors.iterator();
                        }
                        this.competitors.add(addedCompetitorsIter.next());
                    } else {
                        this.competitors.add(previousVersion.competitors.get(this.competitorIndexesInPreviousCompetitorsList[i]));
                    }
                    ++i;
                }
            }
            ArrayList<CompetitorDTO> suppressedCompetitors = new ArrayList<CompetitorDTO>();
            if (this.suppressedCompetitorsUnchanged) {
                Util.addAll(previousVersion.getSuppressedCompetitors(), suppressedCompetitors);
            } else {
                for (CompetitorDTO compactSuppressedCompetitor : this.getSuppressedCompetitors()) {
                    suppressedCompetitors.add(compactSuppressedCompetitor.getCompetitorFromPrevious(previousVersion));
                }
            }
            this.setSuppressedCompetitors(suppressedCompetitors);
            if (this.competitorDisplayNamesUnchanged) {
                this.competitorDisplayNames = previousVersion.competitorDisplayNames;
            } else {
                HashMap<CompetitorDTO, String> expandedCompetitorDisplayNames = new HashMap<CompetitorDTO, String>();
                for (Map.Entry e : this.competitorDisplayNames.entrySet()) {
                    expandedCompetitorDisplayNames.put(((CompetitorDTO)e.getKey()).getCompetitorFromPrevious(previousVersion), (String)e.getValue());
                }
                this.competitorDisplayNames = expandedCompetitorDisplayNames;
            }
            if (this.indexOfUnchangedRaceColumnDTOsInPrevious != null) {
                int i = 0;
                while (i < this.indexOfUnchangedRaceColumnDTOsInPrevious.length) {
                    if (this.indexOfUnchangedRaceColumnDTOsInPrevious[i] != -1) {
                        this.getRaceList().set(i, previousVersion.getRaceList().get(this.indexOfUnchangedRaceColumnDTOsInPrevious[i]));
                    }
                    ++i;
                }
            }
            HashSet<String> columnNamesForWhichToExpandCompetitorOrderingPerRace = new HashSet<String>(this.getCompetitorOrderingPerRaceColumnName().keySet());
            for (String raceColumnNameForWhichCompetitorOrderingPerRaceUnchanged : this.raceColumnNamesForWhichCompetitorOrderingPerRaceUnchanged) {
                this.setCompetitorsFromBestToWorst(raceColumnNameForWhichCompetitorOrderingPerRaceUnchanged, previousVersion.getCompetitorsFromBestToWorst(raceColumnNameForWhichCompetitorOrderingPerRaceUnchanged));
                columnNamesForWhichToExpandCompetitorOrderingPerRace.remove(raceColumnNameForWhichCompetitorOrderingPerRaceUnchanged);
            }
            for (String columnNameForWhichToExpandCompetitorOrderingPerRace : columnNamesForWhichToExpandCompetitorOrderingPerRace) {
                List<CompetitorDTO> competitorsFromBestToWorstForRace = this.getCompetitorsFromBestToWorst(columnNameForWhichToExpandCompetitorOrderingPerRace);
                int i = competitorsFromBestToWorstForRace.size() - 1;
                while (i >= 0) {
                    competitorsFromBestToWorstForRace.set(i, competitorsFromBestToWorstForRace.get(i).getCompetitorFromPrevious(previousVersion));
                    --i;
                }
            }
            if (this.rows == null) {
                this.rows = new HashMap();
            }
            for (CompetitorDTO compactCompetitor : new ArrayList(this.rows.keySet())) {
                CompetitorDTO expandedCompetitor = compactCompetitor.getCompetitorFromPrevious(previousVersion);
                LeaderboardRowDTO row = (LeaderboardRowDTO)this.rows.remove(compactCompetitor);
                row.competitor = expandedCompetitor;
                this.rows.put(expandedCompetitor, row);
            }
            HashSet<String> rowsUnchangedForCompetitorsWithIdAsString = new HashSet<String>();
            if (this.rowsUnchanged != null) {
                for (Map.Entry entry : this.rowsUnchanged.getAllUnchangedCompetitorIdsAsStringAndKeys(previousVersion).entrySet()) {
                    rowsUnchangedForCompetitorsWithIdAsString.add((String)entry.getKey());
                    CompetitorDTO previousCompetitor2 = (CompetitorDTO)competitorsOfPreviousVersionByIdAsString.get(entry.getKey());
                    this.rows.put(previousCompetitor2, (LeaderboardRowDTO)previousVersion.rows.get(previousCompetitor2));
                }
            }
            Map<Object, Object> map2 = map = this.unchangedLeaderboardEntries == null ? new HashMap() : this.unchangedLeaderboardEntries.getAllUnchangedCompetitorIdsAsStringAndKeys(previousVersion);
            if (this.unchangedLeaderboardEntries != null) {
                for (Map.Entry<Object, Object> competitorAndColumnNames : map.entrySet()) {
                    previousCompetitor = (CompetitorDTO)competitorsOfPreviousVersionByIdAsString.get(competitorAndColumnNames.getKey());
                    for (String columnName : (Set)competitorAndColumnNames.getValue()) {
                        if (rowsUnchangedForCompetitorsWithIdAsString.contains(competitorAndColumnNames.getKey())) continue;
                        LeaderboardEntryDTO previousEntry = ((LeaderboardRowDTO)previousVersion.rows.get((Object)previousCompetitor)).fieldsByRaceColumnName.get(columnName);
                        LeaderboardRowDTO row = (LeaderboardRowDTO)this.rows.get(previousCompetitor);
                        if (row == null) continue;
                        row.fieldsByRaceColumnName.put(columnName, previousEntry);
                    }
                }
            }
            if (this.legDetailsUnchanged != null) {
                for (Map.Entry competitorInPreviosAndColumnNameAndLegDetailsIndex : this.legDetailsUnchanged.getAllUnchangedCompetitorIdsAsStringAndKeys(previousVersion).entrySet()) {
                    previousCompetitor = (CompetitorDTO)competitorsOfPreviousVersionByIdAsString.get(competitorInPreviosAndColumnNameAndLegDetailsIndex.getKey());
                    for (Util.Pair columnNameAndLegDetailsIndex : competitorInPreviosAndColumnNameAndLegDetailsIndex.getValue()) {
                        List<LegEntryDTO> previousLegDetails;
                        LeaderboardEntryDTO leaderboardEntry;
                        String raceColumnName = (String)columnNameAndLegDetailsIndex.getA();
                        Set unchangedRaceColumnNamesForCompetitor = (Set)map.get(competitorInPreviosAndColumnNameAndLegDetailsIndex.getKey());
                        if (unchangedRaceColumnNamesForCompetitor != null && unchangedRaceColumnNamesForCompetitor.contains(raceColumnName)) continue;
                        LeaderboardRowDTO leaderboardRowDTO = (LeaderboardRowDTO)this.rows.get(previousCompetitor);
                        LeaderboardEntryDTO leaderboardEntryDTO = leaderboardEntry = leaderboardRowDTO == null ? null : leaderboardRowDTO.fieldsByRaceColumnName.get(raceColumnName);
                        if (leaderboardEntry == null) continue;
                        LeaderboardRowDTO previousLeaderboardRowDTO = (LeaderboardRowDTO)previousVersion.rows.get(previousCompetitor);
                        LeaderboardEntryDTO previousLeaderboardEntryDTO = previousLeaderboardRowDTO == null ? null : previousLeaderboardRowDTO.fieldsByRaceColumnName.get(raceColumnName);
                        List<LegEntryDTO> list = previousLegDetails = previousLeaderboardEntryDTO == null ? null : previousLeaderboardEntryDTO.legDetails;
                        if (previousLegDetails == null) {
                            leaderboardEntry.legDetails = null;
                            continue;
                        }
                        if (leaderboardEntry.legDetails == null) {
                            leaderboardEntry.legDetails = new ArrayList<LegEntryDTO>();
                        }
                        Integer pos = (Integer)columnNameAndLegDetailsIndex.getB();
                        this.ensureSize(leaderboardEntry.legDetails, pos + 1);
                        leaderboardEntry.legDetails.set(pos, previousLegDetails.get(pos));
                    }
                }
            }
            for (LeaderboardRowDTO row : this.rows.values()) {
                if (row == null) continue;
                if (row.effectiveTimeOnDistanceAllowancePerNauticalMile == null) {
                    row.effectiveTimeOnDistanceAllowancePerNauticalMile = row.competitor.getTimeOnDistanceAllowancePerNauticalMile();
                }
                if (row.effectiveTimeOnTimeFactor != null) continue;
                row.effectiveTimeOnTimeFactor = row.competitor.getTimeOnTimeFactor();
            }
            if (this.aclUnchanged) {
                this.setAccessControlList(previousVersion.getAccessControlList());
            }
            if (this.ownershipUnchanged) {
                this.setOwnership(previousVersion.getOwnership());
            }
        }
    }

    private void ensureSize(List<?> list, int size) {
        while (list.size() < size) {
            list.add(null);
        }
    }

    public IncrementalLeaderboardDTO strip(LeaderboardDTO previousVersion) {
        this.isDiffToLeaderboardDTOWithId = previousVersion.getId();
        if (Util.equalsWithNull((Object)this.getComment(), (Object)previousVersion.getComment())) {
            this.setComment(null);
            this.commentUnchanged = true;
        }
        if (Util.equalsWithNull((Object)this.regattaName, (Object)previousVersion.regattaName)) {
            this.regattaName = null;
            this.regattaNameUnchanged = true;
        }
        if (Util.equalsWithNull((Object)this.displayName, (Object)previousVersion.displayName)) {
            this.displayName = null;
            this.displayNameUnchanged = true;
        }
        if (Util.equalsWithNull((Object)this.courseAreas, (Object)previousVersion.courseAreas)) {
            this.courseAreas = null;
            this.courseAreasUnchanged = true;
        }
        if (Util.equalsWithNull((Object)this.getBoatClass(), (Object)previousVersion.getBoatClass())) {
            this.setBoatClass(null);
            this.boatClassUnchanged = true;
        }
        if (Util.equalsWithNull((Object)this.getAccessControlList(), (Object)previousVersion.getAccessControlList())) {
            this.setAccessControlList(null);
            this.aclUnchanged = true;
        }
        if (Util.equalsWithNull((Object)this.getOwnership(), (Object)previousVersion.getOwnership())) {
            this.setOwnership(null);
            this.ownershipUnchanged = true;
        }
        this.competitorIndexesInPreviousCompetitorsList = new int[this.competitors.size()];
        HashMap<CompetitorDTO, CompetitorDTO> compactCompetitorMap = new HashMap<CompetitorDTO, CompetitorDTO>();
        int i = 0;
        for (CompetitorDTO competitor : this.competitors) {
            int n = previousVersion.competitors.indexOf(competitor);
            this.competitorIndexesInPreviousCompetitorsList[i++] = n;
            if (n == -1) {
                if (this.addedCompetitors == null) {
                    this.addedCompetitors = new ArrayList<CompetitorDTO>();
                }
                this.addedCompetitors.add(competitor);
                compactCompetitorMap.put(competitor, competitor);
                continue;
            }
            PreviousCompetitorDTOImpl compactReplacementCompetitor = competitor.hasBoat() ? new PreviousCompetitorWithBoatDTOImpl(n) : new PreviousCompetitorDTOImpl(n);
            compactCompetitorMap.put(competitor, compactReplacementCompetitor);
        }
        this.competitors = null;
        if (Util.equalsWithNull(this.getSuppressedCompetitors(), previousVersion.getSuppressedCompetitors())) {
            this.suppressedCompetitorsUnchanged = true;
            this.setSuppressedCompetitors(null);
        } else {
            ArrayList<CompetitorDTO> compactSuppressedCompetitors = new ArrayList<CompetitorDTO>();
            for (CompetitorDTO suppressedCompetitor : this.getSuppressedCompetitors()) {
                int indexOfSuppressedCompetitorInPreviousSuppressed = Util.indexOf(previousVersion.getSuppressedCompetitors(), (Object)suppressedCompetitor);
                if (indexOfSuppressedCompetitorInPreviousSuppressed == -1) {
                    CompetitorDTO compactedFromPreviousCompetitors = (CompetitorDTO)compactCompetitorMap.get(suppressedCompetitor);
                    if (compactedFromPreviousCompetitors != null) {
                        compactSuppressedCompetitors.add(compactedFromPreviousCompetitors);
                        continue;
                    }
                    compactSuppressedCompetitors.add(suppressedCompetitor);
                    continue;
                }
                compactSuppressedCompetitors.add(new PreviousSuppressedCompetitorDTOImpl(indexOfSuppressedCompetitorInPreviousSuppressed));
            }
            this.setSuppressedCompetitors(compactSuppressedCompetitors);
        }
        if (Util.equalsWithNull((Object)this.competitorDisplayNames, (Object)previousVersion.competitorDisplayNames)) {
            this.competitorDisplayNamesUnchanged = true;
            this.competitorDisplayNames = null;
        } else {
            HashMap<CompetitorDTO, String> compactCompetitorDisplayNames = new HashMap<CompetitorDTO, String>();
            for (Map.Entry e : this.competitorDisplayNames.entrySet()) {
                compactCompetitorDisplayNames.put((CompetitorDTO)compactCompetitorMap.get(e.getKey()), (String)e.getValue());
            }
            this.competitorDisplayNames = compactCompetitorDisplayNames;
        }
        this.raceColumnNamesForWhichCompetitorOrderingPerRaceUnchanged = new HashSet<String>();
        HashMap<String, List<CompetitorDTO>> competitorOrderingPerRaceColumnName = new HashMap<String, List<CompetitorDTO>>(this.getCompetitorOrderingPerRaceColumnName());
        for (RaceColumnDTO raceColumn : this.getRaceList()) {
            List<CompetitorDTO> previousCompetitorsFromBestToWorstForRaceColumn;
            List<CompetitorDTO> competitorsFromBestToWorstForRaceColumn = this.getCompetitorsFromBestToWorst(raceColumn.getName());
            if (Util.equalsWithNull((Object)competitorsFromBestToWorstForRaceColumn, previousCompetitorsFromBestToWorstForRaceColumn = previousVersion.getCompetitorsFromBestToWorst(raceColumn.getName()))) {
                this.raceColumnNamesForWhichCompetitorOrderingPerRaceUnchanged.add(raceColumn.getName());
                competitorOrderingPerRaceColumnName.remove(raceColumn.getName());
                continue;
            }
            ArrayList<CompetitorDTO> compactedCompetitorsFromBestToWorstForRaceColumn = new ArrayList<CompetitorDTO>();
            for (CompetitorDTO competitor : competitorsFromBestToWorstForRaceColumn) {
                compactedCompetitorsFromBestToWorstForRaceColumn.add((CompetitorDTO)compactCompetitorMap.get(competitor));
            }
            competitorOrderingPerRaceColumnName.put(raceColumn.getName(), compactedCompetitorsFromBestToWorstForRaceColumn);
        }
        this.setCompetitorOrderingPerRace(competitorOrderingPerRaceColumnName);
        HashMap<CompetitorDTO, LeaderboardRowDTO> newRows = new HashMap<CompetitorDTO, LeaderboardRowDTO>();
        for (Map.Entry entry : this.rows.entrySet()) {
            CompetitorDTO compactCompetitor;
            CompetitorDTO competitorDTO = (CompetitorDTO)entry.getKey();
            LeaderboardRowDTO previousRowDTO = (LeaderboardRowDTO)previousVersion.rows.get(competitorDTO);
            if (Util.equalsWithNull(entry.getValue(), (Object)previousRowDTO) && previousVersion.competitors.contains(entry.getKey())) {
                this.entireRowUnchanged(previousVersion, (CompetitorDTO)entry.getKey());
                continue;
            }
            LeaderboardRowDTO newRowDTO = new LeaderboardRowDTO();
            this.cloner.clone(entry.getValue(), (Object)newRowDTO);
            if (newRowDTO.effectiveTimeOnDistanceAllowancePerNauticalMile != null && newRowDTO.effectiveTimeOnDistanceAllowancePerNauticalMile.equals(competitorDTO.getTimeOnDistanceAllowancePerNauticalMile())) {
                newRowDTO.effectiveTimeOnDistanceAllowancePerNauticalMile = null;
            }
            if (newRowDTO.effectiveTimeOnTimeFactor != null && newRowDTO.effectiveTimeOnTimeFactor.equals(competitorDTO.getTimeOnTimeFactor())) {
                newRowDTO.effectiveTimeOnTimeFactor = null;
            }
            newRowDTO.competitor = compactCompetitor = (CompetitorDTO)compactCompetitorMap.get(competitorDTO);
            newRows.put(compactCompetitor, newRowDTO);
            HashMap<String, LeaderboardEntryDTO> newFieldsByRaceColumnName = new HashMap<String, LeaderboardEntryDTO>();
            for (Map.Entry<String, LeaderboardEntryDTO> raceColumnNameAndLeaderboardEntry : newRowDTO.fieldsByRaceColumnName.entrySet()) {
                LeaderboardEntryDTO previousEntryDTO = null;
                if (previousRowDTO != null) {
                    previousEntryDTO = previousRowDTO.fieldsByRaceColumnName.get(raceColumnNameAndLeaderboardEntry.getKey());
                }
                if (previousEntryDTO != null && Util.equalsWithNull((Object)raceColumnNameAndLeaderboardEntry.getValue(), previousEntryDTO) && previousVersion.competitors.contains(competitorDTO)) {
                    this.getUnchangedLeaderboardEntries(previousVersion).unchanged(competitorDTO, raceColumnNameAndLeaderboardEntry.getKey());
                    this.getLegDetailsUnchanged(previousVersion).unchanged(competitorDTO, new Util.Pair((Object)raceColumnNameAndLeaderboardEntry.getKey(), null));
                    continue;
                }
                LeaderboardEntryDTO newLeaderboardEntryDTO = new LeaderboardEntryDTO();
                this.cloner.clone((Object)raceColumnNameAndLeaderboardEntry.getValue(), (Object)newLeaderboardEntryDTO);
                if (newLeaderboardEntryDTO.legDetails != null) {
                    newLeaderboardEntryDTO.legDetails = new ArrayList<LegEntryDTO>(newLeaderboardEntryDTO.legDetails);
                }
                newFieldsByRaceColumnName.put(raceColumnNameAndLeaderboardEntry.getKey(), newLeaderboardEntryDTO);
                if (newLeaderboardEntryDTO.legDetails != null) {
                    int legDetailsIndex = 0;
                    while (legDetailsIndex < newLeaderboardEntryDTO.legDetails.size()) {
                        LegEntryDTO legDetails = newLeaderboardEntryDTO.legDetails.get(legDetailsIndex);
                        if (previousEntryDTO != null && previousEntryDTO.legDetails != null && previousEntryDTO.legDetails.size() > legDetailsIndex && Util.equalsWithNull((Object)legDetails, (Object)previousEntryDTO.legDetails.get(legDetailsIndex)) && previousVersion.competitors.contains(competitorDTO)) {
                            this.getLegDetailsUnchanged(previousVersion).unchanged(competitorDTO, new Util.Pair((Object)raceColumnNameAndLeaderboardEntry.getKey(), (Object)legDetailsIndex));
                            newLeaderboardEntryDTO.legDetails.set(legDetailsIndex, null);
                        }
                        ++legDetailsIndex;
                    }
                    continue;
                }
                if (previousEntryDTO != null && previousEntryDTO.legDetails != null || !previousVersion.competitors.contains(competitorDTO)) continue;
                this.getLegDetailsUnchanged(previousVersion).unchanged(competitorDTO, new Util.Pair((Object)raceColumnNameAndLeaderboardEntry.getKey(), null));
            }
            newRowDTO.fieldsByRaceColumnName = newFieldsByRaceColumnName;
        }
        HashMap<CompetitorDTO, LeaderboardRowDTO> hashMap = this.rows = newRows.isEmpty() ? null : newRows;
        if (this.legDetailsUnchanged != null) {
            this.legDetailsUnchanged.compact();
        }
        if (this.getRaceList() != null) {
            ArrayList<RaceColumnDTO> arrayList = new ArrayList<RaceColumnDTO>(this.getRaceList().size());
            this.indexOfUnchangedRaceColumnDTOsInPrevious = new int[this.getRaceList().size()];
            boolean changed = false;
            int raceIndex = 0;
            while (raceIndex < this.getRaceList().size()) {
                int previousIndex;
                this.indexOfUnchangedRaceColumnDTOsInPrevious[raceIndex] = previousIndex = previousVersion.getRaceList().indexOf(this.getRaceList().get(raceIndex));
                if (previousIndex != -1) {
                    arrayList.add(null);
                    changed = true;
                } else {
                    arrayList.add(this.getRaceList().get(raceIndex));
                }
                ++raceIndex;
            }
            if (changed) {
                this.setRaceList(arrayList);
            }
        }
        return this;
    }

    private void entireRowUnchanged(LeaderboardDTO previousVersion, CompetitorDTO competitor) {
        assert (previousVersion.competitors.contains(competitor));
        if (this.rowsUnchanged == null) {
            this.rowsUnchanged = new UnchangedWithCompetitorsInBitSet(previousVersion, this.rows.size());
        }
        this.rowsUnchanged.unchanged(competitor, null);
        LeaderboardRowDTO row = (LeaderboardRowDTO)this.rows.get(competitor);
        if (row != null && row.fieldsByRaceColumnName != null) {
            for (Map.Entry<String, LeaderboardEntryDTO> e : row.fieldsByRaceColumnName.entrySet()) {
                this.getUnchangedLeaderboardEntries(previousVersion).unchanged(competitor, e.getKey());
                this.getLegDetailsUnchanged(previousVersion).unchanged(competitor, new Util.Pair((Object)e.getKey(), null));
            }
        }
    }

    private UnchangedWithCompetitorsInBitSet<String> getUnchangedLeaderboardEntries(LeaderboardDTO previousVersion) {
        if (this.unchangedLeaderboardEntries == null) {
            this.unchangedLeaderboardEntries = new UnchangedWithCompetitorsInBitSet(previousVersion, this.rows.size());
        }
        return this.unchangedLeaderboardEntries;
    }

    private UnchangedLegDetails getLegDetailsUnchanged(LeaderboardDTO previousVersion) {
        if (this.legDetailsUnchanged == null) {
            this.legDetailsUnchanged = new UnchangedLegDetails(previousVersion, this.rows.size());
        }
        return this.legDetailsUnchanged;
    }

    public void setCurrentServerTime(Date currentServerTime) {
        this.currentServerTime = currentServerTime;
    }

    @Override
    public Date getCurrentServerTime() {
        return this.currentServerTime;
    }

    static class UnchangedLegDetails
    extends UnchangedWithCompetitorsInBitSet<Util.Pair<String, Integer>> {
        private static final long serialVersionUID = 8726138955651801210L;

        UnchangedLegDetails() {
        }

        public UnchangedLegDetails(LeaderboardDTO previousLeaderboard, int totalNumberOfCompetitorsInNewLeaderboard) {
            super(previousLeaderboard, totalNumberOfCompetitorsInNewLeaderboard);
        }

        public void compact() {
            for (Util.Pair key : this.getAllUnchangedKeys()) {
                if (key.getB() == null) continue;
                this.tryToCompact(key);
            }
        }

        @Override
        protected int getNumberOfSetBits(Util.Pair<String, Integer> key) {
            int result;
            if (key.getB() != null) {
                long[] bitset = this.getUnchangedBitset(key);
                long[] nullBitset = this.getUnchangedBitset(new Util.Pair((Object)((String)key.getA()), null));
                long[] orBitset = this.or(bitset, nullBitset);
                result = this.getNumberOfBitsSet(orBitset);
            } else {
                result = super.getNumberOfSetBits(key);
            }
            return result;
        }
    }

    static class UnchangedWithCompetitorsInBitSet<K>
    implements Serializable {
        private static final long serialVersionUID = 504599408604780499L;
        private transient int totalNumberOfCompetitorsInNewLeaderboard;
        private transient LeaderboardDTO previousLeaderboard;
        private Map<K, long[]> unchanged;

        UnchangedWithCompetitorsInBitSet() {
        }

        public UnchangedWithCompetitorsInBitSet(LeaderboardDTO previousLeaderboard, int totalNumberOfCompetitorsInNewLeaderboard) {
            this.previousLeaderboard = previousLeaderboard;
            this.totalNumberOfCompetitorsInNewLeaderboard = totalNumberOfCompetitorsInNewLeaderboard;
            this.unchanged = new HashMap<K, long[]>();
        }

        protected long[] or(long[] a, long[] b) {
            int maxLength = Math.max(a == null ? 0 : a.length, b == null ? 0 : b.length);
            long[] result = new long[maxLength];
            int i = 0;
            while (i < maxLength) {
                if (a != null && a.length > i) {
                    int n = i;
                    result[n] = result[n] | a[i];
                }
                if (b != null && b.length > i) {
                    int n = i;
                    result[n] = result[n] | b[i];
                }
                ++i;
            }
            return result;
        }

        protected int getNumberOfSetBits(K key) {
            return this.getNumberOfBitsSet(this.getUnchangedBitset(key));
        }

        protected int getNumberOfBitsSet(long[] bitset) {
            int result = 0;
            int i = 0;
            while (i < bitset.length) {
                int j = 0;
                while (j < 64) {
                    if ((bitset[i] & 1L << j) != 0L) {
                        ++result;
                    }
                    ++j;
                }
                ++i;
            }
            return result;
        }

        private long[] createBitSet(CompetitorDTO competitor) {
            int indexOfCompetitor = this.previousLeaderboard.competitors.indexOf(competitor);
            long[] result = new long[1 + indexOfCompetitor / 64];
            result[indexOfCompetitor / 64] = 1L << indexOfCompetitor % 64;
            return result;
        }

        private int getIndexOfCompetitor(CompetitorDTO competitor) {
            return this.previousLeaderboard.competitors.indexOf(competitor);
        }

        protected int getTotalNumberOfCompetitorsInNewLeaderboard() {
            return this.totalNumberOfCompetitorsInNewLeaderboard;
        }

        public Map<String, Set<K>> getAllUnchangedCompetitorIdsAsStringAndKeys(LeaderboardDTO previousVersion) {
            HashMap<String, Set<K>> result = new HashMap<String, Set<K>>();
            for (Map.Entry<K, long[]> raceColumnNameAndBitSet : this.unchanged.entrySet()) {
                long[] bitset = raceColumnNameAndBitSet.getValue();
                if (bitset == null) {
                    for (CompetitorDTO competitor : previousVersion.competitors) {
                        Util.add(result, (Object)competitor.getIdAsString(), raceColumnNameAndBitSet.getKey());
                    }
                    continue;
                }
                int competitorNumber = 0;
                int arrayIndex = 0;
                while (arrayIndex < bitset.length) {
                    long bitValue = 1L;
                    int bit = 0;
                    while (bit < 64) {
                        if ((bitset[arrayIndex] & bitValue) != 0L) {
                            Util.add(result, (Object)previousVersion.competitors.get(competitorNumber).getIdAsString(), raceColumnNameAndBitSet.getKey());
                        }
                        bitValue <<= 1;
                        ++competitorNumber;
                        ++bit;
                    }
                    ++arrayIndex;
                }
            }
            return result;
        }

        public void unchanged(CompetitorDTO competitor, K key) {
            assert (this.getIndexOfCompetitor(competitor) >= 0);
            long[] bitset = this.getUnchangedBitset(key);
            if (bitset == null) {
                bitset = this.createBitSet(competitor);
                this.unchanged.put(key, bitset);
            } else {
                int indexOfCompetitor = this.getIndexOfCompetitor(competitor);
                if (bitset.length <= indexOfCompetitor / 64) {
                    long[] newBitset = new long[1 + indexOfCompetitor / 64];
                    System.arraycopy(bitset, 0, newBitset, 0, bitset.length);
                    bitset = newBitset;
                    this.unchanged.put(key, bitset);
                }
                int n = indexOfCompetitor / 64;
                bitset[n] = bitset[n] | 1L << indexOfCompetitor % 64;
            }
            this.tryToCompact(key);
        }

        protected void tryToCompact(K key) {
            if (this.getNumberOfSetBits(key) >= this.getTotalNumberOfCompetitorsInNewLeaderboard()) {
                this.unchanged.put(key, null);
            }
        }

        protected long[] getUnchangedBitset(K key) {
            return this.unchanged.get(key);
        }

        protected Set<K> getAllUnchangedKeys() {
            return Collections.unmodifiableSet(this.unchanged.keySet());
        }
    }
}

