/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.dto;

import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sse.common.Color;
import com.sap.sse.common.Duration;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.dto.NamedSecuredObjectDTO;
import java.io.Serializable;

public class CompetitorDTOImpl
extends NamedSecuredObjectDTO
implements CompetitorDTO,
Serializable {
    private static final long serialVersionUID = 3019126418065082622L;
    private String countryName;
    private String twoLetterIsoCountryCode;
    private String threeLetterIocCountryCode;
    private Color color;
    private String shortName;
    private String email;
    private String searchTag;
    private String idAsString;
    private String imageURL;
    private String flagImageURL;
    private Double timeOnTimeFactor;
    private Duration timeOnDistanceAllowancePerNauticalMile;

    protected CompetitorDTOImpl() {
        super("");
    }

    public CompetitorDTOImpl(String name, String shortName, Color color, String email, String twoLetterIsoCountryCode, String threeLetterIocCountryCode, String countryName, String idAsString, String imageURL, String flagImageURL, Double timeOnTimeFactor, Duration timeOnDistanceAllowancePerNauticalMile, String searchTag) {
        super(name);
        this.shortName = shortName;
        this.color = color;
        this.email = email;
        this.twoLetterIsoCountryCode = twoLetterIsoCountryCode;
        this.threeLetterIocCountryCode = threeLetterIocCountryCode;
        this.countryName = countryName;
        this.idAsString = idAsString;
        this.imageURL = imageURL;
        this.flagImageURL = flagImageURL;
        this.timeOnTimeFactor = timeOnTimeFactor;
        this.timeOnDistanceAllowancePerNauticalMile = timeOnDistanceAllowancePerNauticalMile;
        this.searchTag = searchTag;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.idAsString == null ? 0 : this.idAsString.hashCode());
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + (this.shortName == null ? 0 : this.shortName.hashCode());
        result = 31 * result + (this.threeLetterIocCountryCode == null ? 0 : this.threeLetterIocCountryCode.hashCode());
        result = 31 * result + (this.imageURL == null ? 0 : this.imageURL.hashCode());
        result = 31 * result + (this.flagImageURL == null ? 0 : this.flagImageURL.hashCode());
        result = 31 * result + (this.timeOnTimeFactor == null ? 0 : this.timeOnTimeFactor.hashCode());
        result = 31 * result + (this.timeOnDistanceAllowancePerNauticalMile == null ? 0 : this.timeOnDistanceAllowancePerNauticalMile.hashCode());
        result = 31 * result + (this.searchTag == null ? 0 : this.searchTag.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompetitorDTOImpl other = (CompetitorDTOImpl)obj;
        if (this.idAsString == null ? other.idAsString != null : !this.idAsString.equals(other.idAsString)) {
            return false;
        }
        if (this.threeLetterIocCountryCode == null ? other.threeLetterIocCountryCode != null : !this.threeLetterIocCountryCode.equals(other.threeLetterIocCountryCode)) {
            return false;
        }
        if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
            return false;
        }
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        if (this.shortName == null ? other.shortName != null : !this.shortName.equals(other.shortName)) {
            return false;
        }
        if (this.imageURL == null ? other.imageURL != null : !this.imageURL.equals(other.imageURL)) {
            return false;
        }
        if (this.flagImageURL == null ? other.flagImageURL != null : !this.flagImageURL.equals(other.flagImageURL)) {
            return false;
        }
        if (this.timeOnTimeFactor == null ? other.timeOnTimeFactor != null : !this.timeOnTimeFactor.equals(other.timeOnTimeFactor)) {
            return false;
        }
        if (this.timeOnDistanceAllowancePerNauticalMile == null ? other.timeOnDistanceAllowancePerNauticalMile != null : !this.timeOnDistanceAllowancePerNauticalMile.equals(other.timeOnDistanceAllowancePerNauticalMile)) {
            return false;
        }
        return !(this.searchTag == null ? other.searchTag != null : !this.searchTag.equals(other.searchTag));
    }

    @Override
    public CompetitorDTO getCompetitorFromPrevious(LeaderboardDTO previousVersion) {
        return this;
    }

    @Override
    public String getTwoLetterIsoCountryCode() {
        return this.twoLetterIsoCountryCode;
    }

    @Override
    public String getThreeLetterIocCountryCode() {
        return this.threeLetterIocCountryCode;
    }

    @Override
    public String getCountryName() {
        return this.countryName;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getShortInfo() {
        return this.getShortInfo(false);
    }

    @Override
    public String getShortInfo(boolean preferSailId) {
        String trimmedName;
        Object result = this.getShortName() != null && !this.getShortName().trim().isEmpty() ? this.getShortName() : ((trimmedName = this.getName().trim()).isEmpty() ? null : String.valueOf(trimmedName.length() > 0 ? "" + trimmedName.charAt(0) : "") + (trimmedName.length() > 1 ? Character.valueOf(trimmedName.charAt(1)) : "") + (trimmedName.length() > 0 ? Character.valueOf(trimmedName.charAt(trimmedName.length() - 1)) : ""));
        return result;
    }

    @Override
    public String getImageURL() {
        return this.imageURL;
    }

    @Override
    public String getFlagImageURL() {
        return this.flagImageURL;
    }

    @Override
    public String getIdAsString() {
        return this.idAsString;
    }

    public Serializable getId() {
        return this.idAsString;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public String getSearchTag() {
        return this.searchTag;
    }

    @Override
    public void addToSearchTag(String searchTag) {
        if (this.searchTag == null) {
            this.searchTag = searchTag;
        } else if (!this.searchTag.contains(searchTag)) {
            this.searchTag = String.valueOf(this.searchTag) + " " + searchTag;
        }
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public boolean hasEmail() {
        return this.email != null && !this.email.isEmpty();
    }

    @Override
    public Double getTimeOnTimeFactor() {
        return this.timeOnTimeFactor;
    }

    @Override
    public Duration getTimeOnDistanceAllowancePerNauticalMile() {
        return this.timeOnDistanceAllowancePerNauticalMile;
    }

    @Override
    public boolean hasBoat() {
        return false;
    }

    public HasPermissions getPermissionType() {
        return SecuredDomainType.COMPETITOR;
    }

    public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return new TypeRelativeObjectIdentifier(new String[]{this.idAsString});
    }

    @Override
    public void clearNonPublicFields() {
        this.email = null;
    }
}

