/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.dto;

import com.sap.sailing.domain.common.RaceTimesCalculationUtil;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.TrackedRaceDTO;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.dto.NamedDTO;
import java.util.Date;

public class BasicRaceDTO
extends NamedDTO {
    private static final long serialVersionUID = -7884808503795229609L;
    public Date startOfRace;
    public Date endOfRace;
    public Date raceFinishingTime;
    public Date raceFinishedTime;
    public TrackedRaceDTO trackedRace;

    @Deprecated
    BasicRaceDTO() {
    }

    public BasicRaceDTO(RegattaAndRaceIdentifier raceIdentifier, TrackedRaceDTO trackedRace) {
        super(raceIdentifier.getRaceName());
        this.trackedRace = trackedRace;
    }

    public boolean isLive(long serverTimePointAsMillis) {
        Date timePoint = null;
        if (serverTimePointAsMillis != 0L) {
            timePoint = new Date(serverTimePointAsMillis);
        } else if (this.trackedRace != null && this.trackedRace.startOfTracking != null) {
            timePoint = this.trackedRace.startOfTracking;
        } else if (this.startOfRace != null) {
            timePoint = new Date(this.startOfRace.getTime() - 240000L + 1L);
        }
        if (this.trackedRace != null && this.trackedRace.hasGPSData) {
            Date max;
            Util.Pair<Date, Date> minMax = RaceTimesCalculationUtil.calculateRaceMinMax(timePoint, this.trackedRace.startOfTracking, this.startOfRace, this.raceFinishingTime, this.raceFinishedTime, this.endOfRace, this.trackedRace.endOfTracking);
            Date min = minMax.getA() != null ? new Date(((Date)minMax.getA()).getTime() - 240000L) : null;
            Date date = max = minMax.getB() != null ? new Date(((Date)minMax.getB()).getTime() + 180000L + this.trackedRace.delayToLiveInMs) : null;
            if (timePoint != null && min != null && max != null) {
                return !min.after(timePoint) && !timePoint.after(max);
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.endOfRace == null ? 0 : this.endOfRace.hashCode());
        result = 31 * result + (this.startOfRace == null ? 0 : this.startOfRace.hashCode());
        result = 31 * result + (this.trackedRace == null ? 0 : this.trackedRace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BasicRaceDTO other = (BasicRaceDTO)((Object)obj);
        if (this.endOfRace == null ? other.endOfRace != null : !this.endOfRace.equals(other.endOfRace)) {
            return false;
        }
        if (this.startOfRace == null ? other.startOfRace != null : !this.startOfRace.equals(other.startOfRace)) {
            return false;
        }
        return !(this.trackedRace == null ? other.trackedRace != null : !this.trackedRace.equals(other.trackedRace));
    }
}

