/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.confidence.impl;

import com.sap.sailing.domain.common.confidence.Weigher;
import com.sap.sse.common.TimePoint;

public class HyperbolicTimeDifferenceWeigher
implements Weigher<TimePoint> {
    private static final long serialVersionUID = 4378168079868145134L;
    private final long halfConfidenceAfterMilliseconds;

    public HyperbolicTimeDifferenceWeigher(long halfConfidenceAfterMilliseconds) {
        this.halfConfidenceAfterMilliseconds = halfConfidenceAfterMilliseconds;
    }

    @Override
    public double getConfidence(TimePoint fix, TimePoint request) {
        double x = Math.abs(fix.asMillis() - request.asMillis());
        double c = this.halfConfidenceAfterMilliseconds;
        double y = this.halfConfidenceAfterMilliseconds;
        return c / (x + y);
    }
}

