/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common;

import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.WindSourceImpl;
import com.sap.sailing.domain.common.impl.WindSourceWithAdditionalID;
import java.io.Serializable;

public interface WindSource
extends Serializable {
    public WindSourceType getType();

    public boolean canBeStored();

    public String name();

    public Object getId();

    default public String getTypeAndId() {
        return String.valueOf(this.getType().name()) + (this.getId() == null ? "" : " (" + this.getId().toString() + ")");
    }

    public static WindSource fromTypeAndId(String typeAndId) {
        WindSourceImpl result;
        if (typeAndId == null) {
            result = null;
        } else {
            int space = typeAndId.indexOf(32);
            if (space == -1) {
                result = new WindSourceImpl(WindSourceType.valueOf(typeAndId));
            } else {
                WindSourceType type = WindSourceType.valueOf(typeAndId.substring(0, space));
                String id = typeAndId.substring(typeAndId.indexOf(40) + 1, typeAndId.indexOf(41));
                result = new WindSourceWithAdditionalID(type, id);
            }
        }
        return result;
    }
}

