/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common;

import com.sap.sailing.domain.common.CourseChange;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.datamining.annotations.Statistic;

public interface SpeedWithBearing
extends Speed {
    @Statistic(messageKey="bearing", resultDecimals=1)
    public Bearing getBearing();

    public Position travelTo(Position var1, TimePoint var2, TimePoint var3);

    default public Position travelTo(Position from, Duration duration) {
        return from.translateGreatCircle(this.getBearing(), this.travel(duration));
    }

    public CourseChange getCourseChangeRequiredToReach(SpeedWithBearing var1);

    public SpeedWithBearing applyCourseChange(CourseChange var1);

    public Speed projectTo(Position var1, Bearing var2);

    public SpeedWithBearing add(SpeedWithBearing var1);

    default public SpeedWithBearing scale(double d) {
        return new KnotSpeedWithBearingImpl(this.getKnots(), this.getBearing());
    }
}

