/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common;

import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import java.io.Serializable;

public interface Position
extends Serializable {
    public double getLatRad();

    public double getLngRad();

    public double getLatDeg();

    public double getLngDeg();

    public String getAsDegreesAndDecimalMinutesWithCardinalPoints();

    public String getAsSignedDecimalDegrees();

    public double getCentralAngleRad(Position var1);

    public Distance getDistance(Position var1);

    public Bearing getBearingGreatCircle(Position var1);

    public Position translateRhumb(Bearing var1, Distance var2);

    public Position translateGreatCircle(Bearing var1, Distance var2);

    public Position projectToLineThrough(Position var1, Bearing var2);

    public Distance absoluteCrossTrackError(Position var1, Bearing var2);

    public Distance crossTrackError(Position var1, Bearing var2);

    public Distance alongTrackDistance(Position var1, Bearing var2);

    public Distance getDistanceToLine(Position var1, Position var2);

    public Position getLocalCoordinates(Position var1, Bearing var2);

    public Position getTargetCoordinates(Position var1, Bearing var2, Position var3, Bearing var4);

    public double getQuickApproximateNauticalMileDistance(Position var1);

    public Position getIntersection(Bearing var1, Position var2, Bearing var3);

    public SpeedWithBearing getSpeedWithBearingToReachOnGreatCircle(Position var1, Duration var2);
}

