/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.NonCardinalBoundsImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.impl.DegreeBearingImpl;

public interface NonCardinalBounds {
    public static final Bearing NINETY_DEGREE_ANGLE = new DegreeBearingImpl(90.0);

    public static NonCardinalBounds create(Position lowerLeft, Bearing verticalBearing, Distance verticalSize, Distance horizontalSize) {
        return new NonCardinalBoundsImpl(lowerLeft, verticalBearing, verticalSize, horizontalSize);
    }

    public static NonCardinalBounds create(Position p, Bearing verticalBearing) {
        return NonCardinalBounds.create(p, verticalBearing, (Distance)Distance.NULL, (Distance)Distance.NULL);
    }

    public Position getLowerLeft();

    default public Position getUpperLeft() {
        return this.getLowerLeft().translateGreatCircle(this.getVerticalBearing(), this.getVerticalSize());
    }

    default public Position getUpperRight() {
        return this.getUpperLeft().translateGreatCircle(this.getHorizontalBearing(), this.getHorizontalSize());
    }

    default public Position getLowerRight() {
        return this.getLowerLeft().translateGreatCircle(this.getHorizontalBearing(), this.getHorizontalSize());
    }

    public Distance getVerticalSize();

    public Distance getHorizontalSize();

    public NonCardinalBounds extend(Position var1);

    public NonCardinalBounds extend(NonCardinalBounds var1);

    public boolean contains(Position var1);

    public boolean contains(NonCardinalBounds var1);

    public Bearing getVerticalBearing();

    default public Bearing getHorizontalBearing() {
        return this.getVerticalBearing().add(NINETY_DEGREE_ANGLE);
    }

    public Position getCenter();
}

