/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common;

import com.sap.sailing.domain.common.i18n.CommonStringMessages;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum CompetitorRegistrationType {
    CLOSED(false, false),
    OPEN_UNMODERATED(true, false);

    private static final Logger logger;
    private boolean open;
    private boolean moderated;

    static {
        logger = Logger.getLogger(CompetitorRegistrationType.class.getName());
    }

    private CompetitorRegistrationType(boolean open, boolean moderated) {
        this.open = open;
        this.moderated = moderated;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isModerated() {
        return this.moderated;
    }

    public static CompetitorRegistrationType valueOfOrDefault(String name, boolean failForUnknown) {
        if (name == null) {
            return CLOSED;
        }
        try {
            return CompetitorRegistrationType.valueOf(name);
        }
        catch (IllegalArgumentException iae) {
            if (failForUnknown) {
                throw iae;
            }
            logger.log(Level.WARNING, "Unknown CompetitorRegistrationType " + name + " for regatta. Interpreting it to default CLOSED.");
            return CLOSED;
        }
    }

    public static CompetitorRegistrationType valueOfOrDefault(String name) {
        return CompetitorRegistrationType.valueOfOrDefault(name, false);
    }

    public String getLabel(CommonStringMessages stringMessages) {
        switch (this) {
            case CLOSED: {
                return stringMessages.competitorRegistrationTypeClosed();
            }
            case OPEN_UNMODERATED: {
                return stringMessages.competitorRegistrationTypeOpenUnmoderated();
            }
        }
        return this.name();
    }
}

