/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.shared.util.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;

public class DescendingNavigableSet<E>
implements NavigableSet<E> {
    private final NavigableSet<E> set;

    public DescendingNavigableSet(NavigableSet<E> set) {
        if (set == null) {
            throw new IllegalArgumentException();
        }
        this.set = set;
    }

    @Override
    public Comparator<? super E> comparator() {
        return Collections.reverseOrder(this.set.comparator());
    }

    @Override
    public E first() {
        return this.set.last();
    }

    @Override
    public E last() {
        return this.set.first();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int i = 0;
        for (E e : this) {
            result[i++] = e;
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] result = a;
        if (result.length < this.size()) {
            result = new Object[this.size()];
        }
        int i = 0;
        for (E e : this) {
            result[i++] = e;
        }
        Object[] tResult = result;
        return tResult;
    }

    @Override
    public boolean add(E e) {
        return this.set.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.set.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.set.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.set.removeAll(c);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public E lower(E e) {
        return this.set.higher(e);
    }

    @Override
    public E floor(E e) {
        return this.set.ceiling(e);
    }

    @Override
    public E ceiling(E e) {
        return this.set.floor(e);
    }

    @Override
    public E higher(E e) {
        return this.set.lower(e);
    }

    @Override
    public E pollFirst() {
        return this.set.pollLast();
    }

    @Override
    public E pollLast() {
        return this.set.pollFirst();
    }

    @Override
    public Iterator<E> iterator() {
        return this.set.descendingIterator();
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return this.set;
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.set.iterator();
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new DescendingNavigableSet<E>(this.set.subSet(toElement, toInclusive, fromElement, fromInclusive));
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new DescendingNavigableSet<E>(this.set.tailSet(toElement, inclusive));
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new DescendingNavigableSet<E>(this.set.headSet(fromElement, inclusive));
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.tailSet(fromElement, true);
    }
}

