/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.shared.util;

import com.sap.sse.shared.util.WeakReferenceWithKey;
import java.lang.ref.ReferenceQueue;
import java.util.Map;

public class WeakValueCache<K, V> {
    private final Map<K, WeakReferenceWithKey<K, V>> map;
    private final ReferenceQueue<V> queue;

    public WeakValueCache(Map<K, WeakReferenceWithKey<K, V>> map) {
        this.map = map;
        this.queue = new ReferenceQueue();
    }

    public V get(K k) {
        this.purge();
        WeakReferenceWithKey<K, V> result = this.map.get(k);
        return result == null ? null : (V)result.get();
    }

    public V put(K k, V v) {
        V result;
        this.purge();
        WeakReferenceWithKey<K, V> old = this.map.get(k);
        if (old != null) {
            old.cleanUp();
            result = (V)old.get();
        } else {
            result = null;
        }
        this.map.put(k, new WeakReferenceWithKey<K, V>(k, v, this.map, this.queue));
        return result;
    }

    public V remove(K k) {
        V result;
        this.purge();
        WeakReferenceWithKey<K, V> ref = this.map.get(k);
        if (ref != null) {
            result = (V)ref.get();
            ref.cleanUp();
        } else {
            result = null;
        }
        return result;
    }

    private void purge() {
        WeakReferenceWithKey r;
        while ((r = (WeakReferenceWithKey)this.queue.poll()) != null) {
            r.cleanUp();
        }
    }
}

