/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.shared.json;

import com.sap.sse.shared.json.ExtensionJsonSerializer;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.Collections;
import org.json.simple.JSONObject;

public abstract class ExtendableJsonSerializer<T>
implements JsonSerializer<T> {
    private final Iterable<ExtensionJsonSerializer<T, ?>> extensionSerializers;

    protected abstract JSONObject serializeFields(T var1);

    public ExtendableJsonSerializer(Iterable<ExtensionJsonSerializer<T, ?>> extensionSerializers) {
        this.extensionSerializers = extensionSerializers;
    }

    public ExtendableJsonSerializer(ExtensionJsonSerializer<T, ?> extensionSerializer) {
        this.extensionSerializers = Collections.singletonList(extensionSerializer);
    }

    public ExtendableJsonSerializer() {
        this.extensionSerializers = Collections.emptyList();
    }

    @Override
    public JSONObject serialize(T object) {
        JSONObject result = this.serializeFields(object);
        for (ExtensionJsonSerializer<T, ?> extensionSerializer : this.extensionSerializers) {
            result.put((Object)extensionSerializer.getExtensionFieldName(), extensionSerializer.serializeExtension(object));
        }
        return result;
    }
}

