/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.concurrent;

import com.sap.sse.common.Util;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentWeakHashMap<K, V>
implements Map<K, V> {
    private final ConcurrentHashMap<WeakReferenceThatIsEqualToItselfAndItsReferent, V> map = new ConcurrentHashMap();
    private final ReferenceQueue<K> queue = new ReferenceQueue();

    private void purgeStaleEntries() {
        Reference<K> ref;
        while ((ref = this.queue.poll()) != null) {
            this.map.remove(ref);
        }
    }

    @Override
    public int size() {
        this.purgeStaleEntries();
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        this.purgeStaleEntries();
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.purgeStaleEntries();
        return this.map.containsKey(new WeakReferenceThatIsEqualToItselfAndItsReferent(key, null));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        this.purgeStaleEntries();
        return this.map.get(new WeakReferenceThatIsEqualToItselfAndItsReferent(key, null));
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(new WeakReferenceThatIsEqualToItselfAndItsReferent(key, this.queue), value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(new WeakReferenceThatIsEqualToItselfAndItsReferent(key, null));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return ConcurrentWeakHashMap.this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentWeakHashMap.this.map.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            ConcurrentWeakHashMap.this.purgeStaleEntries();
            final Iterator iterator = ConcurrentWeakHashMap.this.map.entrySet().iterator();
            return new Iterator<Map.Entry<K, V>>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    final Map.Entry e = (Map.Entry)iterator.next();
                    return new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return ((WeakReferenceThatIsEqualToItselfAndItsReferent)e.getKey()).get();
                        }

                        @Override
                        public V getValue() {
                            return e.getValue();
                        }

                        @Override
                        public V setValue(V value) {
                            return e.setValue(value);
                        }
                    };
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public int size() {
            return ConcurrentWeakHashMap.this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentWeakHashMap.this.map.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentWeakHashMap.this.map.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return ConcurrentWeakHashMap.this.map.remove(o) != null;
        }

        @Override
        public Iterator<K> iterator() {
            ConcurrentWeakHashMap.this.purgeStaleEntries();
            final Iterator iterator = ConcurrentWeakHashMap.this.map.entrySet().iterator();
            return new Iterator<K>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public K next() {
                    return ((WeakReferenceThatIsEqualToItselfAndItsReferent)((Map.Entry)iterator.next()).getKey()).get();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }
    }

    private class WeakReferenceThatIsEqualToItselfAndItsReferent
    extends WeakReference<K> {
        private final int hashCode;

        public WeakReferenceThatIsEqualToItselfAndItsReferent(K referent, ReferenceQueue<? super K> q) {
            super(referent, q);
            this.hashCode = referent.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            boolean result;
            if (other == this) {
                result = true;
            } else {
                WeakReferenceThatIsEqualToItselfAndItsReferent otherAsRef = (WeakReferenceThatIsEqualToItselfAndItsReferent)other;
                Object referent = this.get();
                Object otherReferent = otherAsRef.get();
                result = Util.equalsWithNull(referent, otherReferent);
            }
            return result;
        }
    }
}

