/*
 * Decompiled with CFR 0.152.
 */
package difflib;

import difflib.ChangeDelta;
import difflib.Chunk;
import difflib.Delta;
import difflib.DiffAlgorithm;
import difflib.Patch;
import difflib.PatchFailedException;
import difflib.myers.MyersDiff;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DiffUtils {
    private static Pattern unifiedDiffChunkRe = Pattern.compile("^@@\\s+-(?:(\\d+)(?:,(\\d+))?)\\s+\\+(?:(\\d+)(?:,(\\d+))?)\\s+@@$");

    public static <T> Patch<T> diff(Iterable<T> original, Iterable<T> revised) {
        return DiffUtils.diff(original, revised, new MyersDiff());
    }

    public static <T> Patch<T> diff(Iterable<T> original, Iterable<T> revised, DiffAlgorithm<T> algorithm) {
        return algorithm.diff(original, revised);
    }

    public static <T> List<T> patch(List<T> original, Patch<T> patch) throws PatchFailedException {
        return patch.applyTo(original);
    }

    public static <T> List<T> unpatch(List<T> revised, Patch<T> patch) {
        return patch.restore(revised);
    }

    public static Patch<String> parseUnifiedDiff(List<String> diff) {
        String rest;
        String tag;
        boolean inPrelude = true;
        ArrayList<Object[]> rawChunk = new ArrayList<Object[]>();
        Patch<String> patch = new Patch<String>();
        int old_ln = 0;
        int new_ln = 0;
        for (String line : diff) {
            if (inPrelude) {
                if (!line.startsWith("+++")) continue;
                inPrelude = false;
                continue;
            }
            Matcher m = unifiedDiffChunkRe.matcher(line);
            if (m.find()) {
                if (rawChunk.size() != 0) {
                    ArrayList<String> oldChunkLines = new ArrayList<String>();
                    ArrayList<String> newChunkLines = new ArrayList<String>();
                    for (Object[] raw_line : rawChunk) {
                        tag = (String)raw_line[0];
                        rest = (String)raw_line[1];
                        if (tag.equals(" ") || tag.equals("-")) {
                            oldChunkLines.add(rest);
                        }
                        if (!tag.equals(" ") && !tag.equals("+")) continue;
                        newChunkLines.add(rest);
                    }
                    patch.addDelta(new ChangeDelta(new Chunk(old_ln - 1, oldChunkLines), new Chunk(new_ln - 1, newChunkLines)));
                    rawChunk.clear();
                }
                old_ln = m.group(1) == null ? 1 : Integer.parseInt(m.group(1));
                int n = new_ln = m.group(3) == null ? 1 : Integer.parseInt(m.group(3));
                if (old_ln == 0) {
                    ++old_ln;
                }
                if (new_ln != 0) continue;
                ++new_ln;
                continue;
            }
            if (line.length() > 0) {
                tag = line.substring(0, 1);
                rest = line.substring(1);
                if (!tag.equals(" ") && !tag.equals("+") && !tag.equals("-")) continue;
                rawChunk.add(new Object[]{tag, rest});
                continue;
            }
            rawChunk.add(new Object[]{" ", ""});
        }
        if (rawChunk.size() != 0) {
            ArrayList<String> oldChunkLines = new ArrayList<String>();
            ArrayList<String> newChunkLines = new ArrayList<String>();
            for (Object[] raw_line : rawChunk) {
                tag = (String)raw_line[0];
                rest = (String)raw_line[1];
                if (tag.equals(" ") || tag.equals("-")) {
                    oldChunkLines.add(rest);
                }
                if (!tag.equals(" ") && !tag.equals("+")) continue;
                newChunkLines.add(rest);
            }
            patch.addDelta(new ChangeDelta(new Chunk(old_ln - 1, oldChunkLines), new Chunk(new_ln - 1, newChunkLines)));
            rawChunk.clear();
        }
        return patch;
    }

    public static List<String> generateUnifiedDiff(String original, String revised, List<String> originalLines, Patch<String> patch, int contextSize) {
        if (!patch.getDeltas().isEmpty()) {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add("--- " + original);
            ret.add("+++ " + revised);
            ArrayList<Delta<String>> patchDeltas = new ArrayList<Delta<String>>(patch.getDeltas());
            ArrayList<Delta<String>> deltas = new ArrayList<Delta<String>>();
            Delta delta = (Delta)patchDeltas.get(0);
            deltas.add(delta);
            if (patchDeltas.size() > 1) {
                int i = 1;
                while (i < patchDeltas.size()) {
                    int position = delta.getOriginal().getPosition();
                    Delta nextDelta = (Delta)patchDeltas.get(i);
                    if (position + delta.getOriginal().size() + contextSize >= nextDelta.getOriginal().getPosition() - contextSize) {
                        deltas.add(nextDelta);
                    } else {
                        List<String> curBlock = DiffUtils.processDeltas(originalLines, deltas, contextSize);
                        ret.addAll(curBlock);
                        deltas.clear();
                        deltas.add(nextDelta);
                    }
                    delta = nextDelta;
                    ++i;
                }
            }
            List<String> curBlock = DiffUtils.processDeltas(originalLines, deltas, contextSize);
            ret.addAll(curBlock);
            return ret;
        }
        return new ArrayList<String>();
    }

    private static List<String> processDeltas(List<String> origLines, List<Delta<String>> deltas, int contextSize) {
        int contextStart;
        int revStart;
        ArrayList<String> buffer = new ArrayList<String>();
        int origTotal = 0;
        int revTotal = 0;
        Delta<String> curDelta = deltas.get(0);
        int origStart = curDelta.getOriginal().getPosition() + 1 - contextSize;
        if (origStart < 1) {
            origStart = 1;
        }
        if ((revStart = curDelta.getRevised().getPosition() + 1 - contextSize) < 1) {
            revStart = 1;
        }
        if ((contextStart = curDelta.getOriginal().getPosition() - contextSize) < 0) {
            contextStart = 0;
        }
        int line = contextStart;
        while (line < curDelta.getOriginal().getPosition()) {
            buffer.add(" " + origLines.get(line));
            ++origTotal;
            ++revTotal;
            ++line;
        }
        buffer.addAll(DiffUtils.getDeltaText(curDelta));
        origTotal += curDelta.getOriginal().getLines().size();
        revTotal += curDelta.getRevised().getLines().size();
        int deltaIndex = 1;
        while (deltaIndex < deltas.size()) {
            int intermediateStart;
            Delta<String> nextDelta = deltas.get(deltaIndex);
            line = intermediateStart = curDelta.getOriginal().getPosition() + curDelta.getOriginal().getLines().size();
            while (line < nextDelta.getOriginal().getPosition()) {
                buffer.add(" " + origLines.get(line));
                ++origTotal;
                ++revTotal;
                ++line;
            }
            buffer.addAll(DiffUtils.getDeltaText(nextDelta));
            origTotal += nextDelta.getOriginal().getLines().size();
            revTotal += nextDelta.getRevised().getLines().size();
            curDelta = nextDelta;
            ++deltaIndex;
        }
        line = contextStart = curDelta.getOriginal().getPosition() + curDelta.getOriginal().getLines().size();
        while (line < contextStart + contextSize && line < origLines.size()) {
            buffer.add(" " + origLines.get(line));
            ++origTotal;
            ++revTotal;
            ++line;
        }
        StringBuffer header = new StringBuffer();
        header.append("@@ -");
        header.append(origStart);
        header.append(",");
        header.append(origTotal);
        header.append(" +");
        header.append(revStart);
        header.append(",");
        header.append(revTotal);
        header.append(" @@");
        buffer.add(0, header.toString());
        return buffer;
    }

    private static List<String> getDeltaText(Delta<String> delta) {
        ArrayList<String> buffer = new ArrayList<String>();
        for (String line : delta.getOriginal().getLines()) {
            buffer.add("-" + line);
        }
        for (String line : delta.getRevised().getLines()) {
            buffer.add("+" + line);
        }
        return buffer;
    }
}

