/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.ess40.resultimport.impl;

import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.domain.common.ScoreCorrectionProvider;
import com.sap.sailing.ess40.resultimport.impl.RegattaScoreCorrectionsImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScoreCorrectionProviderImpl
implements ScoreCorrectionProvider {
    private static final long serialVersionUID = -4870646572106575667L;
    private static final String EXTREME_40_CLASS_NAME = "Extreme40";

    public String getName() {
        return "Extreme Sailing Series 40 Scores from SailRacer.org";
    }

    private List<URL> getCsvUrls(String ... actNames) throws MalformedURLException {
        ArrayList<URL> result = new ArrayList<URL>();
        String[] stringArray = actNames;
        int n = actNames.length;
        int n2 = 0;
        while (n2 < n) {
            String actName = stringArray[n2];
            result.add(new URL("https://static.sapsailing.com/ESSResults/" + actName + ".csv"));
            ++n2;
        }
        return result;
    }

    private Util.Pair<TimePoint, Map<String, List<Util.Pair<String, Double>>>> getActResults(URL actUrl) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)actUrl.openConnection();
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36");
        MillisecondsTimePoint lastModified = new MillisecondsTimePoint(conn.getLastModified());
        InputStream inputStream = (InputStream)conn.getContent();
        return new Util.Pair((Object)lastModified, this.parseResults(inputStream));
    }

    protected Map<String, List<Util.Pair<String, Double>>> parseResults(InputStream inputStream) throws IOException {
        HashMap<String, List<Util.Pair<String, Double>>> result = new HashMap<String, List<Util.Pair<String, Double>>>();
        Pattern quotedCompetitorNameAndAllTheRest = Pattern.compile("^\"([^\"]*)\",(.*)$");
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        String line = br.readLine();
        while (line != null) {
            String[] split;
            String sailID;
            Matcher quotedCompetitorNameAndAllTheRestMatcher = quotedCompetitorNameAndAllTheRest.matcher(line);
            if (quotedCompetitorNameAndAllTheRestMatcher.matches()) {
                sailID = quotedCompetitorNameAndAllTheRestMatcher.group(1);
                split = quotedCompetitorNameAndAllTheRestMatcher.group(2).split(",");
            } else {
                String[] preSplit = line.split(",");
                sailID = preSplit[0].trim();
                if (sailID.startsWith("\"") && sailID.endsWith("\"")) {
                    sailID = sailID.substring(1, sailID.length() - 1);
                }
                split = new String[preSplit.length - 1];
                System.arraycopy(preSplit, 1, split, 0, split.length);
            }
            ArrayList<Util.Pair> competitorEntry = new ArrayList<Util.Pair>();
            result.put(sailID, competitorEntry);
            int i = 0;
            while (i < split.length - 1) {
                String rankOrMaxPointsReason = split[i];
                Double points = Double.valueOf(split[i + 1]);
                competitorEntry.add(new Util.Pair((Object)rankOrMaxPointsReason, (Object)points));
                i += 2;
            }
            line = br.readLine();
        }
        return result;
    }

    public Map<String, Set<Util.Pair<String, TimePoint>>> getHasResultsForBoatClassFromDateByEventName() throws Exception {
        HashMap<String, Set<Util.Pair<String, TimePoint>>> result = new HashMap<String, Set<Util.Pair<String, TimePoint>>>();
        for (String actName : this.getAvailableActNames()) {
            URL actUrl = this.getCsvUrls(actName).iterator().next();
            Util.Pair<TimePoint, Map<String, List<Util.Pair<String, Double>>>> actResults = this.getActResults(actUrl);
            result.put(actName, Collections.singleton(new Util.Pair((Object)EXTREME_40_CLASS_NAME, (Object)((TimePoint)actResults.getA()))));
        }
        return result;
    }

    private Iterable<String> getAvailableActNames() throws IOException {
        String readLine;
        ArrayList<String> result = new ArrayList<String>();
        URL url = new URL("https://static.sapsailing.com/ESSResults/");
        Pattern p = Pattern.compile("<a href=\"([^\"]*)\\.csv\">");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36");
        conn.setRequestProperty("accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8");
        conn.setRequestProperty("accept-language", "en-US,en;q=0.8,de;q=0.6,da;q=0.4");
        Charset charset = HttpUrlConnectionHelper.getCharsetFromConnectionOrDefault((URLConnection)conn, (String)"UTF-8");
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), charset));
        while ((readLine = br.readLine()) != null) {
            Matcher m = p.matcher(readLine);
            if (!m.find()) continue;
            result.add(m.group(1));
        }
        return result;
    }

    public RegattaScoreCorrections getScoreCorrections(String actName, String boatClassName, TimePoint timePoint) throws Exception {
        URL actUrl = this.getCsvUrls(actName).iterator().next();
        Util.Pair<TimePoint, Map<String, List<Util.Pair<String, Double>>>> actResults = this.getActResults(actUrl);
        return new RegattaScoreCorrectionsImpl(this, (Map)actResults.getB());
    }

    public RegattaScoreCorrections getScoreCorrections(InputStream inputStream) throws Exception {
        return new RegattaScoreCorrectionsImpl(this, this.parseResults(inputStream));
    }
}

