/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.sentence;

import net.sf.marineapi.nmea.sentence.SentenceValidator;

public enum SentenceId {
    ALK,
    APB,
    BOD,
    CUR,
    DBT,
    DPT,
    DTM,
    GGA,
    GLL,
    GNS,
    GSA,
    GSV,
    GST,
    HDG,
    HDM,
    HDT,
    MHU,
    MMB,
    MTA,
    MTW,
    MWV,
    RMB,
    RMC,
    ROT,
    RPM,
    RSA,
    RTE,
    TTM,
    VBW,
    VDM,
    VDO,
    VDR,
    VLW,
    VTG,
    VHW,
    WPL,
    VWR,
    VWT,
    XDR,
    XTE,
    MDA,
    MWD,
    ZDA;


    public static SentenceId parse(String nmea) {
        String sid = SentenceId.parseStr(nmea);
        return SentenceId.valueOf(sid);
    }

    public static String parseStr(String nmea) {
        if (!SentenceValidator.isSentence(nmea)) {
            throw new IllegalArgumentException("String is not a sentence");
        }
        String id = null;
        id = nmea.startsWith("$P") ? nmea.substring(2, nmea.indexOf(44)) : nmea.substring(3, nmea.indexOf(44));
        return id;
    }
}

