/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import java.util.Date;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.sentence.ZDASentence;
import net.sf.marineapi.nmea.util.Time;

class ZDAParser
extends SentenceParser
implements ZDASentence {
    private static final int UTC_TIME = 0;
    private static final int DAY = 1;
    private static final int MONTH = 2;
    private static final int YEAR = 3;
    private static final int LOCAL_ZONE_HOURS = 4;
    private static final int LOCAL_ZONE_MINUTES = 5;

    public ZDAParser(String nmea) {
        super(nmea, SentenceId.ZDA);
    }

    public ZDAParser(TalkerId talker) {
        super(talker, SentenceId.ZDA, 6);
    }

    @Override
    public net.sf.marineapi.nmea.util.Date getDate() {
        int y = this.getIntValue(3);
        int m = this.getIntValue(2);
        int d = this.getIntValue(1);
        return new net.sf.marineapi.nmea.util.Date(y, m, d);
    }

    @Override
    public int getLocalZoneHours() {
        return this.getIntValue(4);
    }

    @Override
    public int getLocalZoneMinutes() {
        return this.getIntValue(5);
    }

    @Override
    public Time getTime() {
        String str = this.getStringValue(0);
        int tzHrs = this.getLocalZoneHours();
        int tzMin = this.getLocalZoneMinutes();
        Time t = new Time(str);
        t.setOffsetHours(tzHrs);
        t.setOffsetMinutes(tzMin);
        return t;
    }

    @Override
    public void setDate(net.sf.marineapi.nmea.util.Date date) {
        this.setIntValue(3, date.getYear());
        this.setIntValue(2, date.getMonth(), 2);
        this.setIntValue(1, date.getDay(), 2);
    }

    @Override
    public void setLocalZoneHours(int hours) {
        if (hours < -13 || hours > 13) {
            throw new IllegalArgumentException("Value must be within range -13..13");
        }
        this.setIntValue(4, hours, 2);
    }

    @Override
    public void setLocalZoneMinutes(int minutes) {
        if (minutes < -59 || minutes > 59) {
            throw new IllegalArgumentException("Value must be within range -59..59");
        }
        this.setIntValue(5, minutes, 2);
    }

    @Override
    public void setTime(Time t) {
        this.setStringValue(0, t.toString());
    }

    @Override
    public void setTimeAndLocalZone(Time t) {
        this.setTime(t);
        this.setLocalZoneHours(t.getOffsetHours());
        this.setLocalZoneMinutes(t.getOffsetMinutes());
    }

    @Override
    public Date toDate() {
        net.sf.marineapi.nmea.util.Date d = this.getDate();
        Time t = this.getTime();
        return t.toDate(d.toDate());
    }
}

