/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.sentence.XTESentence;
import net.sf.marineapi.nmea.util.DataStatus;
import net.sf.marineapi.nmea.util.Direction;
import net.sf.marineapi.nmea.util.FaaMode;

class XTEParser
extends SentenceParser
implements XTESentence {
    private static final int SIGNAL_STATUS = 0;
    private static final int CYCLE_LOCK_STATUS = 1;
    private static final int DISTANCE = 2;
    private static final int DIRECTION = 3;
    private static final int DISTANCE_UNIT = 4;
    private static final int FAA_MODE = 5;

    public XTEParser(String nmea) {
        super(nmea);
        this.setFieldCount(6);
    }

    public XTEParser(TalkerId talker) {
        super(talker, SentenceId.XTE, 6);
        this.setMode(FaaMode.NONE);
        this.setStatus(DataStatus.VOID);
        this.setCycleLockStatus(DataStatus.VOID);
        this.setCharValue(4, 'N');
    }

    @Override
    public DataStatus getCycleLockStatus() {
        return DataStatus.valueOf(this.getCharValue(1));
    }

    @Override
    public double getMagnitude() {
        return this.getDoubleValue(2);
    }

    @Override
    public FaaMode getMode() {
        return FaaMode.valueOf(this.getCharValue(5));
    }

    @Override
    public DataStatus getStatus() {
        return DataStatus.valueOf(this.getCharValue(0));
    }

    @Override
    public Direction getSteerTo() {
        return Direction.valueOf(this.getCharValue(3));
    }

    @Override
    public void setCycleLockStatus(DataStatus status) {
        this.setCharValue(1, status.toChar());
    }

    @Override
    public void setMagnitude(double distance) {
        this.setDoubleValue(2, distance, 0, 2);
    }

    @Override
    public void setMode(FaaMode mode) {
        this.setCharValue(5, mode.toChar());
    }

    @Override
    public void setStatus(DataStatus status) {
        this.setCharValue(0, status.toChar());
    }

    @Override
    public void setSteerTo(Direction direction) {
        this.setCharValue(3, direction.toChar());
    }
}

