/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TTMSentence;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.AcquisitionType;
import net.sf.marineapi.nmea.util.TargetStatus;
import net.sf.marineapi.nmea.util.Time;
import net.sf.marineapi.nmea.util.Units;

class TTMParser
extends SentenceParser
implements TTMSentence {
    private static final int NUMBER = 0;
    private static final int DISTANCE = 1;
    private static final int BEARING = 2;
    private static final int BEARING_TRUE_REL = 3;
    private static final int SPEED = 4;
    private static final int COURSE = 5;
    private static final int COURSE_TRUE_REL = 6;
    private static final int DISTANCE_CPA = 7;
    private static final int TIME_CPA = 8;
    private static final int UNITS = 9;
    private static final int NAME = 10;
    private static final int STATUS = 11;
    private static final int REFERENCE = 12;
    private static final int UTC_TIME = 13;
    private static final int ACQUISITON_TYPE = 14;

    public TTMParser(String nmea) {
        super(nmea, SentenceId.TTM);
    }

    public TTMParser(TalkerId talker) {
        super(talker, SentenceId.TTM, 15);
    }

    @Override
    public Time getTime() {
        String str = this.getStringValue(13);
        return new Time(str);
    }

    @Override
    public void setTime(Time t) {
        String str = String.format("%02d%02d", t.getHour(), t.getMinutes());
        DecimalFormat nf = new DecimalFormat("00.00");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        nf.setDecimalFormatSymbols(dfs);
        str = String.valueOf(str) + nf.format(t.getSeconds());
        this.setStringValue(13, str);
    }

    @Override
    public int getNumber() {
        return this.getIntValue(0);
    }

    @Override
    public double getDistance() {
        return this.getDoubleValue(1);
    }

    @Override
    public double getBearing() {
        return this.getDoubleValue(2);
    }

    @Override
    public double getSpeed() {
        return this.getDoubleValue(4);
    }

    @Override
    public double getCourse() {
        return this.getDoubleValue(5);
    }

    @Override
    public double getDistanceOfCPA() {
        return this.getDoubleValue(7);
    }

    @Override
    public double getTimeToCPA() {
        return this.getDoubleValue(8);
    }

    @Override
    public Units getUnits() {
        return Units.valueOf(this.getCharValue(9));
    }

    @Override
    public String getName() {
        return this.getStringValue(10);
    }

    @Override
    public TargetStatus getStatus() {
        return TargetStatus.valueOf(this.getCharValue(11));
    }

    @Override
    public AcquisitionType getAcquisitionType() {
        return AcquisitionType.valueOf(this.getCharValue(14));
    }

    @Override
    public boolean getReference() {
        return this.getCharValue(12) == 'R';
    }

    @Override
    public void setNumber(int number) {
        this.setIntValue(0, number, 2);
    }

    @Override
    public void setDistance(double distance) {
        this.setDoubleValue(1, distance, 1, 1);
        this.setCharValue(9, 'N');
    }

    @Override
    public void setBearing(double bearing) {
        this.setDoubleValue(2, bearing, 1, 1);
        this.setCharValue(3, 'T');
    }

    @Override
    public void setSpeed(double speed) {
        this.setDoubleValue(4, speed, 1, 1);
        this.setCharValue(9, 'N');
    }

    @Override
    public void setCourse(double course) {
        this.setDoubleValue(5, course, 1, 1);
        this.setCharValue(6, 'T');
    }

    @Override
    public void setDistanceOfCPA(double distance) {
        this.setDoubleValue(7, distance, 1, 1);
        this.setCharValue(9, 'N');
    }

    @Override
    public void setTimeToCPA(double minutes) {
        this.setDoubleValue(8, minutes, 1, 1);
    }

    @Override
    public void setName(String name) {
        this.setStringValue(10, name);
    }

    @Override
    public void setStatus(TargetStatus status) {
        this.setCharValue(11, status.toChar());
    }

    @Override
    public void setReference(boolean isReference) {
        if (isReference) {
            this.setCharValue(12, 'R');
        }
    }

    @Override
    public void setAcquisitionType(AcquisitionType acquisitionType) {
        this.setCharValue(14, acquisitionType.toChar());
    }
}

