/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.RSASentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.DataStatus;
import net.sf.marineapi.nmea.util.Side;

class RSAParser
extends SentenceParser
implements RSASentence {
    private static final int STARBOARD_SENSOR = 0;
    private static final int STARBOARD_STATUS = 1;
    private static final int PORT_SENSOR = 2;
    private static final int PORT_STATUS = 3;

    public RSAParser(String nmea) {
        super(nmea, SentenceId.RSA);
    }

    public RSAParser(TalkerId talker) {
        super(talker, SentenceId.RSA, 4);
        this.setStatus(Side.STARBOARD, DataStatus.VOID);
        this.setStatus(Side.PORT, DataStatus.VOID);
    }

    @Override
    public double getRudderAngle(Side side) {
        if (Side.STARBOARD.equals((Object)side)) {
            return this.getDoubleValue(0);
        }
        return this.getDoubleValue(2);
    }

    @Override
    public void setRudderAngle(Side side, double angle) {
        if (Side.STARBOARD.equals((Object)side)) {
            this.setDoubleValue(0, angle);
        } else {
            this.setDoubleValue(2, angle);
        }
    }

    @Override
    public DataStatus getStatus(Side side) {
        if (Side.STARBOARD.equals((Object)side)) {
            return DataStatus.valueOf(this.getCharValue(1));
        }
        return DataStatus.valueOf(this.getCharValue(3));
    }

    @Override
    public void setStatus(Side side, DataStatus status) {
        if (Side.STARBOARD.equals((Object)side)) {
            this.setCharValue(1, status.toChar());
        } else {
            this.setCharValue(3, status.toChar());
        }
    }
}

