/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.MWDSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;

class MWDParser
extends SentenceParser
implements MWDSentence {
    private static int WIND_DIRECTION_TRUE = 0;
    private static int WIND_DIRECTION_TRUE_UNIT = 1;
    private static int WIND_DIRECTION_MAGNETIC = 2;
    private static int WIND_DIRECTION_MAGNETIC_UNIT = 3;
    private static int WIND_SPEED_KNOTS = 4;
    private static int WIND_SPEED_KNOTS_UNIT = 5;
    private static int WIND_SPEED_METERS = 6;
    private static int WIND_SPEED_METERS_UNIT = 7;

    public MWDParser(String nmea) {
        super(nmea, SentenceId.MWD);
    }

    public MWDParser(TalkerId talker) {
        super(talker, SentenceId.MWD, 8);
        this.setCharValue(WIND_DIRECTION_TRUE_UNIT, 'T');
        this.setCharValue(WIND_DIRECTION_MAGNETIC_UNIT, 'M');
        this.setCharValue(WIND_SPEED_METERS_UNIT, 'M');
        this.setCharValue(WIND_SPEED_KNOTS_UNIT, 'N');
    }

    @Override
    public double getMagneticWindDirection() {
        if (this.hasValue(WIND_DIRECTION_MAGNETIC) && this.hasValue(WIND_DIRECTION_MAGNETIC_UNIT) && this.getStringValue(WIND_DIRECTION_MAGNETIC_UNIT).equalsIgnoreCase("M")) {
            return this.getDoubleValue(WIND_DIRECTION_MAGNETIC);
        }
        return Double.NaN;
    }

    @Override
    public double getTrueWindDirection() {
        if (this.hasValue(WIND_DIRECTION_TRUE) && this.hasValue(WIND_DIRECTION_TRUE_UNIT) && this.getStringValue(WIND_DIRECTION_TRUE_UNIT).equalsIgnoreCase("T")) {
            return this.getDoubleValue(WIND_DIRECTION_TRUE);
        }
        return Double.NaN;
    }

    @Override
    public double getWindSpeed() {
        if (this.hasValue(WIND_SPEED_METERS) && this.hasValue(WIND_SPEED_METERS_UNIT) && this.getStringValue(WIND_SPEED_METERS_UNIT).equalsIgnoreCase("M")) {
            return this.getDoubleValue(WIND_SPEED_METERS);
        }
        return Double.NaN;
    }

    @Override
    public double getWindSpeedKnots() {
        if (this.hasValue(WIND_SPEED_KNOTS) && this.hasValue(WIND_SPEED_KNOTS_UNIT) && this.getStringValue(WIND_SPEED_KNOTS_UNIT).equalsIgnoreCase("N")) {
            return this.getDoubleValue(WIND_SPEED_KNOTS);
        }
        return Double.NaN;
    }

    @Override
    public void setMagneticWindDirection(double direction) {
        this.setDegreesValue(WIND_DIRECTION_MAGNETIC, direction);
    }

    @Override
    public void setTrueWindDirection(double direction) {
        this.setDegreesValue(WIND_DIRECTION_TRUE, direction);
    }

    @Override
    public void setWindSpeed(double speed) {
        this.setDoubleValue(WIND_SPEED_METERS, speed);
    }

    @Override
    public void setWindSpeedKnots(double speed) {
        this.setDoubleValue(WIND_SPEED_KNOTS, speed);
    }
}

