/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.MDASentence;
import net.sf.marineapi.nmea.sentence.TalkerId;

class MDAParser
extends SentenceParser
implements MDASentence {
    public static final String MDA_SENTENCE_ID = "MDA";
    private static int PRIMARY_BAROMETRIC_PRESSURE = 0;
    private static int PRIMARY_BAROMETRIC_PRESSURE_UNIT = 1;
    private static int SECONDARY_BAROMETRIC_PRESSURE = 2;
    private static int SECONDARY_BAROMETRIC_PRESSURE_UNIT = 3;
    private static int AIR_TEMPERATURE = 4;
    private static int AIR_TEMPERATURE_UNIT = 5;
    private static int WATER_TEMPERATURE = 6;
    private static int WATER_TEMPERATURE_UNIT = 7;
    private static int RELATIVE_HUMIDITY = 8;
    private static int ABSOLUTE_HUMIDITY = 9;
    private static int DEW_POINT = 10;
    private static int DEW_POINT_UNIT = 11;
    private static int WIND_DIRECTION_TRUE = 12;
    private static int WIND_DIRECTION_TRUE_UNIT = 13;
    private static int WIND_DIRECTION_MAGNETIC = 14;
    private static int WIND_DIRECTION_MAGNETIC_UNIT = 15;
    private static int WIND_SPEED_KNOTS = 16;
    private static int WIND_SPEED_KNOTS_UNIT = 17;
    private static int WIND_SPEED_METERS = 18;
    private static int WIND_SPEED_METERS_UNIT = 19;

    public MDAParser(String nmea) {
        super(nmea, MDA_SENTENCE_ID);
    }

    public MDAParser(TalkerId talker) {
        super(talker, MDA_SENTENCE_ID, 20);
        this.setCharValue(AIR_TEMPERATURE_UNIT, 'C');
        this.setCharValue(WATER_TEMPERATURE_UNIT, 'C');
        this.setCharValue(DEW_POINT_UNIT, 'C');
        this.setCharValue(WIND_DIRECTION_TRUE_UNIT, 'T');
        this.setCharValue(WIND_DIRECTION_MAGNETIC_UNIT, 'M');
        this.setCharValue(WIND_SPEED_KNOTS_UNIT, 'K');
        this.setCharValue(WIND_SPEED_METERS_UNIT, 'M');
        this.setCharValue(PRIMARY_BAROMETRIC_PRESSURE_UNIT, 'I');
        this.setCharValue(SECONDARY_BAROMETRIC_PRESSURE_UNIT, 'B');
    }

    @Override
    public double getAbsoluteHumidity() {
        if (this.hasValue(ABSOLUTE_HUMIDITY)) {
            return this.getDoubleValue(ABSOLUTE_HUMIDITY);
        }
        return Double.NaN;
    }

    @Override
    public double getAirTemperature() {
        if (this.hasValue(AIR_TEMPERATURE)) {
            return this.getDoubleValue(AIR_TEMPERATURE);
        }
        return Double.NaN;
    }

    @Override
    public double getDewPoint() {
        if (this.hasValue(DEW_POINT)) {
            return this.getDoubleValue(DEW_POINT);
        }
        return Double.NaN;
    }

    @Override
    public double getMagneticWindDirection() {
        if (this.hasValue(WIND_DIRECTION_MAGNETIC)) {
            return this.getDoubleValue(WIND_DIRECTION_MAGNETIC);
        }
        return Double.NaN;
    }

    @Override
    public double getPrimaryBarometricPressure() {
        if (this.hasValue(PRIMARY_BAROMETRIC_PRESSURE)) {
            return this.getDoubleValue(PRIMARY_BAROMETRIC_PRESSURE);
        }
        return Double.NaN;
    }

    @Override
    public char getPrimaryBarometricPressureUnit() {
        return this.getCharValue(PRIMARY_BAROMETRIC_PRESSURE_UNIT);
    }

    @Override
    public double getRelativeHumidity() {
        if (this.hasValue(RELATIVE_HUMIDITY)) {
            return this.getDoubleValue(RELATIVE_HUMIDITY);
        }
        return Double.NaN;
    }

    @Override
    public double getSecondaryBarometricPressure() {
        if (this.hasValue(SECONDARY_BAROMETRIC_PRESSURE)) {
            return this.getDoubleValue(SECONDARY_BAROMETRIC_PRESSURE);
        }
        return Double.NaN;
    }

    @Override
    public char getSecondaryBarometricPressureUnit() {
        return this.getCharValue(SECONDARY_BAROMETRIC_PRESSURE_UNIT);
    }

    @Override
    public double getTrueWindDirection() {
        if (this.hasValue(WIND_DIRECTION_TRUE)) {
            return this.getDoubleValue(WIND_DIRECTION_TRUE);
        }
        return Double.NaN;
    }

    @Override
    public double getWaterTemperature() {
        if (this.hasValue(WATER_TEMPERATURE)) {
            return this.getDoubleValue(WATER_TEMPERATURE);
        }
        return Double.NaN;
    }

    @Override
    public double getWindSpeed() {
        if (this.hasValue(WIND_SPEED_METERS)) {
            return this.getDoubleValue(WIND_SPEED_METERS);
        }
        return Double.NaN;
    }

    @Override
    public double getWindSpeedKnots() {
        if (this.hasValue(WIND_SPEED_KNOTS)) {
            return this.getDoubleValue(WIND_SPEED_KNOTS);
        }
        return Double.NaN;
    }

    @Override
    public void setAbsoluteHumidity(double humitidy) {
        this.setDoubleValue(ABSOLUTE_HUMIDITY, humitidy);
    }

    @Override
    public void setAirTemperature(double temp) {
        this.setDoubleValue(AIR_TEMPERATURE, temp);
    }

    @Override
    public void setDewPoint(double dewPoint) {
        this.setDoubleValue(DEW_POINT, dewPoint);
    }

    @Override
    public void setMagneticWindDirection(double direction) {
        this.setDoubleValue(WIND_DIRECTION_MAGNETIC, direction);
    }

    @Override
    public void setPrimaryBarometricPressure(double pressure) {
        this.setDoubleValue(PRIMARY_BAROMETRIC_PRESSURE, pressure);
    }

    @Override
    public void setPrimaryBarometricPressureUnit(char unit) {
        this.setCharValue(PRIMARY_BAROMETRIC_PRESSURE_UNIT, unit);
    }

    @Override
    public void setRelativeHumidity(double humidity) {
        this.setDoubleValue(RELATIVE_HUMIDITY, humidity);
    }

    @Override
    public void setSecondaryBarometricPressure(double pressure) {
        this.setDoubleValue(SECONDARY_BAROMETRIC_PRESSURE, pressure);
    }

    @Override
    public void setSecondaryBarometricPressureUnit(char unit) {
        this.setCharValue(SECONDARY_BAROMETRIC_PRESSURE_UNIT, unit);
    }

    @Override
    public void setTrueWindDirection(double direction) {
        this.setDoubleValue(WIND_DIRECTION_TRUE, direction);
    }

    @Override
    public void setWaterTemperature(double temp) {
        this.setDoubleValue(WATER_TEMPERATURE, temp);
    }

    @Override
    public void setWindSpeed(double speed) {
        this.setDoubleValue(WIND_SPEED_METERS, speed);
    }

    @Override
    public void setWindSpeedKnots(double speed) {
        this.setDoubleValue(WIND_SPEED_KNOTS, speed);
    }
}

