/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.DBTSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.Units;

class DBTParser
extends SentenceParser
implements DBTSentence {
    private static final int DEPTH_FEET = 0;
    private static final int FEET = 1;
    private static final int DEPTH_METERS = 2;
    private static final int METERS = 3;
    private static final int DEPTH_FATHOMS = 4;
    private static final int FATHOMS = 5;

    public DBTParser(String nmea) {
        super(nmea, SentenceId.DBT);
    }

    public DBTParser(TalkerId talker) {
        super(talker, SentenceId.DBT, 6);
        this.setCharValue(1, Units.FEET.toChar());
        this.setCharValue(3, Units.METER.toChar());
        this.setCharValue(5, Units.FATHOMS.toChar());
    }

    @Override
    public double getDepth() {
        return this.getDoubleValue(2);
    }

    @Override
    public double getFathoms() {
        return this.getDoubleValue(4);
    }

    @Override
    public double getFeet() {
        return this.getDoubleValue(0);
    }

    @Override
    public void setDepth(double depth) {
        this.setDoubleValue(2, depth, 1, 1);
    }

    @Override
    public void setFathoms(double depth) {
        this.setDoubleValue(4, depth, 1, 1);
    }

    @Override
    public void setFeet(double depth) {
        this.setDoubleValue(0, depth, 1, 1);
    }
}

