/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.util;

import java.text.DecimalFormat;

public class PositionInfo {
    private static final DecimalFormat COORD_FORMAT = new DecimalFormat("##0.000000;-##0.000000");
    private static final int LONGITUDE_NOTAVAILABLE = 181;
    public static final String LONGITUDE_RANGE = "[-180.0, 180.0] + {181}";
    private static final int LATITUDE_NOTAVAILABLE = 91;
    public static final String LATITUDE_RANGE = "[-90.0, 90.0] + {91}";

    public static boolean isLongitudeCorrect(double value) {
        return PositionInfo.isLongitudeAvailable(value) || value == 181.0;
    }

    public static boolean isLongitudeAvailable(double value) {
        return -180.0 <= value && value <= 180.0;
    }

    public static String longitudeToString(double value) {
        String msg = PositionInfo.isLongitudeCorrect(value) ? (PositionInfo.isLongitudeAvailable(value) ? COORD_FORMAT.format(value) : "longitude not available") : "invalid longitude";
        return msg;
    }

    public static boolean isLatitudeCorrect(double value) {
        return PositionInfo.isLatitudeAvailable(value) || value == 91.0;
    }

    public static boolean isLatitudeAvailable(double value) {
        return -90.0 <= value && value <= 90.0;
    }

    public static String latitudeToString(double value) {
        String msg = PositionInfo.isLatitudeCorrect(value) ? (PositionInfo.isLatitudeAvailable(value) ? COORD_FORMAT.format(value) : "latitude not available") : "invalid latitude";
        return msg;
    }
}

