/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.parser;

import net.sf.marineapi.ais.message.AISMessage24;
import net.sf.marineapi.ais.parser.AISMessageParser;
import net.sf.marineapi.ais.util.ShipType;
import net.sf.marineapi.ais.util.Sixbit;

class AISMessage24Parser
extends AISMessageParser
implements AISMessage24 {
    private static final int PARTNUMBER = 0;
    private static final int NAME = 1;
    private static final int TYPEOFSHIPANDCARGO = 1;
    private static final int VENDORID = 2;
    private static final int UNITMODELCODE = 3;
    private static final int SERIALNUMBER = 4;
    private static final int CALLSIGN = 5;
    private static final int BOW = 6;
    private static final int STERN = 7;
    private static final int PORT = 8;
    private static final int STARBOARD = 9;
    private static final int[] FROM_A = new int[]{38, 40, 160};
    private static final int[] TO_A = new int[]{40, 160, 168};
    private static final int[] FROM_B = new int[]{38, 40, 48, 66, 70, 90, 132, 141, 150, 156};
    private static final int[] TO_B = new int[]{40, 48, 66, 70, 90, 132, 141, 150, 156, 162};
    private int fPartNumber;
    private String fName;
    private int fShipAndCargoType;
    private String fVendorId;
    private int fUnitModelCode;
    private int fSerialNumber;
    private String fCallSign;
    private int fBow;
    private int fStern;
    private int fPort;
    private int fStarboard;

    public AISMessage24Parser(Sixbit content) {
        super(content);
        this.fPartNumber = content.getInt(FROM_A[0], TO_A[0]);
        if (content.length() != 160 && content.length() != 168) {
            throw new IllegalArgumentException("Wrong message length");
        }
        this.fPartNumber = content.getInt(FROM_A[0], TO_A[0]);
        if (this.fPartNumber == 0 && (content.length() == 160 || content.length() == 168)) {
            this.fName = content.getString(FROM_A[1], TO_A[1]);
        } else if (this.fPartNumber == 1 && content.length() == 168) {
            this.fShipAndCargoType = content.getInt(FROM_B[1], TO_B[1]);
            this.fVendorId = content.getString(FROM_B[2], TO_B[2]);
            this.fUnitModelCode = content.getInt(FROM_B[3], TO_B[3]);
            this.fSerialNumber = content.getInt(FROM_B[4], TO_B[4]);
            this.fCallSign = content.getString(FROM_B[5], TO_B[5]);
            this.fBow = content.getInt(FROM_B[6], TO_B[6]);
            this.fStern = content.getInt(FROM_B[7], TO_B[7]);
            this.fPort = content.getInt(FROM_B[8], TO_B[8]);
            this.fStarboard = content.getInt(FROM_B[9], TO_B[9]);
        } else {
            throw new IllegalArgumentException("Wrong part number / message length");
        }
    }

    @Override
    public int getPartNumber() {
        return this.fPartNumber;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public int getTypeOfShipAndCargoType() {
        return this.fShipAndCargoType;
    }

    @Override
    public String getVendorId() {
        return this.fVendorId;
    }

    @Override
    public int getUnitModelCode() {
        return this.fUnitModelCode;
    }

    @Override
    public int getSerialNumber() {
        return this.fSerialNumber;
    }

    @Override
    public String getCallSign() {
        return this.fCallSign;
    }

    @Override
    public int getBow() {
        return this.fBow;
    }

    @Override
    public int getStern() {
        return this.fStern;
    }

    @Override
    public int getPort() {
        return this.fPort;
    }

    @Override
    public int getStarboard() {
        return this.fStarboard;
    }

    public String toString() {
        String result = "\tName:      " + this.fName;
        result = String.valueOf(result) + "\n\tType:      " + ShipType.shipTypeToString(this.fShipAndCargoType);
        result = String.valueOf(result) + "\n\tVendor id:      " + this.fVendorId;
        result = String.valueOf(result) + "\n\tUnit Model Code:      " + this.fUnitModelCode;
        result = String.valueOf(result) + "\n\tSerial Number:      " + this.fSerialNumber;
        result = String.valueOf(result) + "\n\tCall sign: " + this.fCallSign;
        String dim = "Bow: " + this.fBow + ", Stern: " + this.fStern + ", Port: " + this.fPort + ", Starboard: " + this.fStarboard + " [m]";
        result = String.valueOf(result) + "\n\tDim:       " + dim;
        return result;
    }
}

