/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import smile.regression.LASSO;
import smile.regression.Regression;

public class ElasticNet
implements Regression<double[]> {
    private static final long serialVersionUID = 1L;
    private double lambda1 = 0.1;
    private double lambda2 = 0.1;
    private int p;
    private double[] w;
    private double b;
    private LASSO lasso;
    private double c;

    public ElasticNet(double[][] x, double[] y, double lambda1, double lambda2) {
        this(x, y, lambda1, lambda2, 1.0E-4, 1000);
    }

    public ElasticNet(double[][] x, double[] y, double lambda1, double lambda2, double tol, int maxIter) {
        if (lambda1 <= 0.0) {
            throw new IllegalArgumentException("Please use Ridge instead, wrong L1 portion setting:" + lambda1);
        }
        if (lambda2 <= 0.0) {
            throw new IllegalArgumentException("Please use LASSO instead, wrong L2 portion setting:" + lambda2);
        }
        this.lambda1 = lambda1;
        this.lambda2 = lambda2;
        this.c = 1.0 / Math.sqrt(1.0 + lambda2);
        this.p = x[0].length;
        this.lasso = new LASSO(this.getAugmentedData(x), this.getAugmentedResponse(y), this.lambda1 * this.c, tol, maxIter);
        this.w = new double[this.lasso.coefficients().length];
        double rescale = 1.0 / this.c;
        for (int i = 0; i < this.w.length; ++i) {
            this.w[i] = rescale * this.lasso.coefficients()[i];
        }
        this.b = rescale * this.lasso.intercept();
    }

    @Override
    public double predict(double[] x) {
        if (x.length != this.p) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.p));
        }
        return smile.math.Math.dot((double[])x, (double[])this.w) + this.b;
    }

    public double[] coefficients() {
        return this.w;
    }

    public double intercept() {
        return this.b;
    }

    public LASSO lasso() {
        return this.lasso;
    }

    private double[] getAugmentedResponse(double[] y) {
        double[] ret = new double[y.length + this.p];
        System.arraycopy(y, 0, ret, 0, y.length);
        return ret;
    }

    private double[][] getAugmentedData(double[][] x) {
        int i;
        double[][] ret = new double[x.length + this.p][this.p];
        double padding = this.c * Math.sqrt(this.lambda2);
        for (i = 0; i < x.length; ++i) {
            for (int j = 0; j < this.p; ++j) {
                ret[i][j] = this.c * x[i][j];
            }
        }
        for (i = x.length; i < ret.length; ++i) {
            ret[i][i - x.length] = padding;
        }
        return ret;
    }
}

