/*
 * Decompiled with CFR 0.152.
 */
package smile.association;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.association.FPTree;
import smile.association.ItemSet;
import smile.association.TotalSupportTree;
import smile.util.MulticoreExecutor;

public class FPGrowth {
    private static final Logger logger = LoggerFactory.getLogger(FPGrowth.class);
    private int minSupport;
    private FPTree T0;

    public FPGrowth(int[] frequency, int minSupport) {
        this.minSupport = minSupport;
        this.T0 = new FPTree(frequency, minSupport);
    }

    public FPGrowth(int[][] itemsets, double minSupport) {
        this(itemsets, (int)Math.ceil((double)itemsets.length * minSupport));
    }

    public FPGrowth(int[][] itemsets, int minSupport) {
        this.minSupport = minSupport;
        this.T0 = new FPTree(itemsets, minSupport);
    }

    public void add(int[] itemset) {
        this.T0.add(itemset);
    }

    public int size() {
        return this.T0.size();
    }

    public List<ItemSet> learn() {
        ArrayList<ItemSet> list = new ArrayList<ItemSet>();
        this.learn(null, list, null);
        return list;
    }

    public long learn(PrintStream out) {
        return this.learn(out, null, null);
    }

    TotalSupportTree buildTotalSupportTree() {
        TotalSupportTree ttree = new TotalSupportTree(this.minSupport, this.T0.numFreqItems, this.T0.order);
        this.learn(null, null, ttree);
        return ttree;
    }

    private long learn(PrintStream out, List<ItemSet> list, TotalSupportTree ttree) {
        if (MulticoreExecutor.getThreadPoolSize() > 1) {
            return this.grow(out, list, ttree, this.T0, null, null, null);
        }
        return this.grow(out, list, ttree, this.T0, null);
    }

    private long grow(PrintStream out, List<ItemSet> list, TotalSupportTree ttree, FPTree fptree, int[] itemset) {
        long n = 0L;
        int[] prefixItemset = new int[this.T0.maxItemSetSize];
        int[] localItemSupport = new int[this.T0.numItems];
        int i = fptree.headerTable.length;
        while (i-- > 0) {
            n += this.grow(out, list, ttree, fptree.headerTable[i], itemset, localItemSupport, prefixItemset);
        }
        return n;
    }

    private long grow(PrintStream out, List<ItemSet> list, TotalSupportTree ttree, FPTree fptree, int[] itemset, int[] localItemSupport, int[] prefixItemset) {
        if (fptree == this.T0) {
            int i;
            int nprocs = MulticoreExecutor.getThreadPoolSize();
            ArrayList headers = new ArrayList();
            for (i = 0; i < 2 * nprocs; ++i) {
                headers.add(new ArrayList());
            }
            i = fptree.headerTable.length;
            while (i-- > 0) {
                ((List)headers.get(i % headers.size())).add(fptree.headerTable[i]);
            }
            ArrayList<FPGrowthTask> tasks = new ArrayList<FPGrowthTask>();
            for (int i2 = 0; i2 < headers.size(); ++i2) {
                tasks.add(new FPGrowthTask((List)headers.get(i2), out, list, ttree));
            }
            long n = 0L;
            try {
                List results = MulticoreExecutor.run(tasks);
                Iterator iterator = results.iterator();
                while (iterator.hasNext()) {
                    long i3 = (Long)iterator.next();
                    n += i3;
                }
            }
            catch (Exception e) {
                logger.error("Failed to run FPGrowth on multi-core", (Throwable)e);
            }
            return n;
        }
        long n = 0L;
        int i = fptree.headerTable.length;
        while (i-- > 0) {
            n += this.grow(out, list, ttree, fptree.headerTable[i], itemset, localItemSupport, prefixItemset);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collect(PrintStream out, List<ItemSet> list, TotalSupportTree ttree, int[] itemset, int support) {
        Object object;
        if (list != null) {
            object = list;
            synchronized (object) {
                list.add(new ItemSet(itemset, support));
            }
        }
        if (out != null) {
            object = out;
            synchronized (object) {
                for (int i = 0; i < itemset.length; ++i) {
                    out.format("%d ", itemset[i]);
                }
                out.format("(%d)%n", support);
            }
        }
        if (ttree != null) {
            object = ttree;
            synchronized (object) {
                ttree.add(itemset, support);
            }
        }
    }

    private long grow(PrintStream out, List<ItemSet> list, TotalSupportTree ttree, FPTree.Node node, int[] itemset, int support) {
        int height = 0;
        FPTree.Node currentNode = node;
        while (currentNode != null) {
            ++height;
            currentNode = currentNode.parent;
        }
        int n = 0;
        if (height > 0) {
            int[] items = new int[height];
            int i = 0;
            FPTree.Node currentNode2 = node;
            while (currentNode2 != null) {
                items[i++] = currentNode2.id;
                currentNode2 = currentNode2.parent;
            }
            int[] itemIndexStack = new int[height];
            int itemIndexStackPos = 0;
            itemset = FPGrowth.insert(itemset, items[itemIndexStack[itemIndexStackPos]]);
            this.collect(out, list, ttree, itemset, support);
            ++n;
            while (itemIndexStack[0] < height - 1) {
                if (itemIndexStack[itemIndexStackPos] < height - 1) {
                    itemIndexStack[++itemIndexStackPos] = itemIndexStack[itemIndexStackPos - 1] + 1;
                    itemset = FPGrowth.insert(itemset, items[itemIndexStack[itemIndexStackPos]]);
                    this.collect(out, list, ttree, itemset, support);
                    ++n;
                    continue;
                }
                if ((itemset = FPGrowth.drop(itemset)) == null) continue;
                itemIndexStack[--itemIndexStackPos] = itemIndexStack[itemIndexStackPos] + 1;
                itemset[0] = items[itemIndexStack[itemIndexStackPos]];
                this.collect(out, list, ttree, itemset, support);
                ++n;
            }
        }
        return n;
    }

    private long grow(PrintStream out, List<ItemSet> list, TotalSupportTree ttree, FPTree.HeaderTableItem header, int[] itemset, int[] localItemSupport, int[] prefixItemset) {
        long n = 1L;
        int support = header.count;
        int item = header.id;
        itemset = FPGrowth.insert(itemset, item);
        this.collect(out, list, ttree, itemset, support);
        if (header.node.next == null) {
            FPTree.Node node = header.node;
            n += this.grow(out, list, ttree, node.parent, itemset, support);
        } else if (this.getLocalItemSupport(header.node, localItemSupport)) {
            FPTree fptree = this.getLocalFPTree(header.node, localItemSupport, prefixItemset);
            n += this.grow(out, list, ttree, fptree, itemset, localItemSupport, prefixItemset);
        }
        return n;
    }

    private boolean getLocalItemSupport(FPTree.Node node, int[] localItemSupport) {
        boolean end = true;
        Arrays.fill(localItemSupport, 0);
        while (node != null) {
            int support = node.count;
            FPTree.Node parent = node.parent;
            while (parent != null) {
                int n = parent.id;
                localItemSupport[n] = localItemSupport[n] + support;
                parent = parent.parent;
                end = false;
            }
            node = node.next;
        }
        return !end;
    }

    private FPTree getLocalFPTree(FPTree.Node node, int[] localItemSupport, int[] prefixItemset) {
        FPTree tree = new FPTree(localItemSupport, this.minSupport);
        while (node != null) {
            FPTree.Node parent = node.parent;
            int i = prefixItemset.length;
            while (parent != null) {
                if (localItemSupport[parent.id] >= this.minSupport) {
                    prefixItemset[--i] = parent.id;
                }
                parent = parent.parent;
            }
            if (i < prefixItemset.length) {
                tree.add(i, prefixItemset.length, prefixItemset, node.count);
            }
            node = node.next;
        }
        return tree;
    }

    static int[] insert(int[] itemset, int item) {
        if (itemset == null) {
            int[] newItemset = new int[]{item};
            return newItemset;
        }
        int n = itemset.length + 1;
        int[] newItemset = new int[n];
        newItemset[0] = item;
        System.arraycopy(itemset, 0, newItemset, 1, n - 1);
        return newItemset;
    }

    static int[] drop(int[] itemset) {
        if (itemset.length >= 1) {
            int n = itemset.length - 1;
            int[] newItemset = new int[n];
            System.arraycopy(itemset, 1, newItemset, 0, n);
            return newItemset;
        }
        return null;
    }

    class FPGrowthTask
    implements Callable<Long> {
        List<FPTree.HeaderTableItem> headers;
        PrintStream out;
        List<ItemSet> list;
        TotalSupportTree ttree;
        int[] prefixItemset = null;
        int[] localItemSupport = null;

        FPGrowthTask(List<FPTree.HeaderTableItem> headers, PrintStream out, List<ItemSet> list, TotalSupportTree ttree) {
            this.headers = headers;
            this.out = out;
            this.list = list;
            this.ttree = ttree;
            this.prefixItemset = new int[((FPGrowth)FPGrowth.this).T0.maxItemSetSize];
            this.localItemSupport = new int[((FPGrowth)FPGrowth.this).T0.numItems];
        }

        @Override
        public Long call() {
            long n = 0L;
            for (FPTree.HeaderTableItem header : this.headers) {
                n += FPGrowth.this.grow(this.out, (List<ItemSet>)this.list, this.ttree, header, null, this.localItemSupport, this.prefixItemset);
            }
            return n;
        }
    }
}

